/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.io;

public class ByteCounter {
    private long count;
    private ByteCounter addedCounter;

    public ByteCounter() {
    }

    public ByteCounter(ByteCounter counter) {
        this.addedCounter = counter;
    }

    public synchronized long getByteCount() {
        if (this.addedCounter != null) {
            return this.count + this.addedCounter.getByteCount();
        }
        return this.count;
    }

    public synchronized void add(long nbBytes) {
        if (nbBytes > 0L) {
            this.count += nbBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void add(ByteCounter counter, boolean resetAfter) {
        ByteCounter byteCounter = counter;
        synchronized (byteCounter) {
            this.add(counter.getByteCount());
            if (resetAfter) {
                counter.reset();
            }
        }
    }

    public synchronized void reset() {
        this.count = 0L;
    }
}

