/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.io;

import com.mucommander.commons.io.ByteCounter;
import java.io.IOException;
import java.io.InputStream;

public class CounterInputStream
extends InputStream {
    private final InputStream in;
    private final ByteCounter counter;
    private boolean countSkippedBytes = true;

    public CounterInputStream(InputStream in, ByteCounter counter) {
        this.in = in;
        this.counter = counter;
    }

    public int read() throws IOException {
        int i = this.in.read();
        if (i > 0) {
            this.counter.add(1L);
        }
        return i;
    }

    public int read(byte[] b) throws IOException {
        int nbRead = this.in.read(b);
        if (nbRead > 0) {
            this.counter.add(nbRead);
        }
        return nbRead;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int nbRead = this.in.read(b, off, len);
        if (nbRead > 0) {
            this.counter.add(nbRead);
        }
        return nbRead;
    }

    public long skip(long n) throws IOException {
        long nbSkipped = this.in.skip(n);
        if (this.countSkippedBytes && nbSkipped > 0L) {
            this.counter.add(nbSkipped);
        }
        return nbSkipped;
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
    }

    public void mark(int readLimit) {
        this.in.mark(readLimit);
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public void reset() throws IOException {
        this.in.reset();
    }
}

