/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.io;

import com.mucommander.commons.io.ByteCounter;
import java.io.IOException;
import java.io.OutputStream;

public class CounterOutputStream
extends OutputStream {
    private final OutputStream out;
    private final ByteCounter counter;

    public CounterOutputStream(OutputStream out, ByteCounter counter) {
        this.out = out;
        this.counter = counter;
    }

    public void write(int b) throws IOException {
        this.out.write(b);
        this.counter.add(1L);
    }

    public void write(byte[] b) throws IOException {
        this.out.write(b);
        this.counter.add(b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.counter.add(len);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }
}

