/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.io;

import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import com.mucommander.commons.io.BufferPool;
import com.mucommander.commons.io.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncodingDetector {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncodingDetector.class);

    public static String detectEncoding(byte[] bytes) {
        return EncodingDetector.detectEncoding(bytes, 0, bytes.length);
    }

    public static String detectEncoding(byte[] bytes, int off, int len) {
        if (len < 4) {
            return null;
        }
        if (len > 4096) {
            len = 4096;
        }
        if (off > 0 || len < bytes.length) {
            byte[] tmp = new byte[len];
            System.arraycopy(bytes, off, tmp, 0, len);
            bytes = tmp;
        }
        CharsetDetector cd = new CharsetDetector();
        cd.setText(bytes);
        CharsetMatch cm = cd.detect();
        LOGGER.trace("bestMatch getName()={}, getConfidence()={}", cm == null ? "null" : cm.getName(), cm == null ? "null" : Integer.toString(cm.getConfidence()));
        return cm == null ? null : cm.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String detectEncoding(InputStream in) throws IOException {
        byte[] buf = BufferPool.getByteArray(4096);
        try {
            String string = EncodingDetector.detectEncoding(buf, 0, StreamUtils.readUpTo(in, buf));
            return string;
        }
        finally {
            BufferPool.releaseByteArray(buf);
        }
    }
}

