/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.io;

import java.io.IOException;
import java.io.InputStream;

public class ThroughputLimitInputStream
extends InputStream {
    private InputStream in;
    private long bpsLimit;
    private long currentSecond;
    private long nbBytesReadThisSecond;

    public ThroughputLimitInputStream(InputStream in, long bytesPerSecond) {
        this.in = in;
        this.bpsLimit = bytesPerSecond;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThroughputLimit(long bytesPerSecond) {
        this.bpsLimit = bytesPerSecond;
        ThroughputLimitInputStream throughputLimitInputStream = this;
        synchronized (throughputLimitInputStream) {
            this.notify();
        }
    }

    public void setUnderlyingInputStream(InputStream in) {
        this.in = in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNbAllowedBytes() {
        long allowedBytes;
        long msUntilNextSecond = this.updateLimitCounter();
        ThroughputLimitInputStream throughputLimitInputStream = this;
        synchronized (throughputLimitInputStream) {
            while ((allowedBytes = this.bpsLimit - this.nbBytesReadThisSecond) <= 0L) {
                if (this.bpsLimit < 0L) {
                    return Integer.MAX_VALUE;
                }
                try {
                    if (this.bpsLimit == 0L) {
                        this.wait();
                    } else {
                        this.wait(msUntilNextSecond);
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                msUntilNextSecond = this.updateLimitCounter();
            }
        }
        return (int)allowedBytes;
    }

    private long updateLimitCounter() {
        long now = System.currentTimeMillis();
        long nowSecond = now / 1000L;
        if (this.currentSecond != nowSecond) {
            this.currentSecond = nowSecond;
            this.nbBytesReadThisSecond = 0L;
        }
        return 1000L - now % 1000L;
    }

    private void addToLimitCounter(long nbRead) {
        this.updateLimitCounter();
        this.nbBytesReadThisSecond += nbRead;
    }

    public int read() throws IOException {
        int i;
        if (this.bpsLimit >= 0L) {
            this.getNbAllowedBytes();
        }
        if ((i = this.in.read()) > 0) {
            this.addToLimitCounter(1L);
        }
        return i;
    }

    public int read(byte[] bytes) throws IOException {
        return this.read(bytes, 0, bytes.length);
    }

    public int read(byte[] bytes, int off, int len) throws IOException {
        int nbRead = this.bpsLimit >= 0L ? this.in.read(bytes, off, Math.min(this.getNbAllowedBytes(), len)) : this.in.read(bytes, off, len);
        if (nbRead > 0) {
            this.addToLimitCounter(nbRead);
        }
        return nbRead;
    }

    public long skip(long l) throws IOException {
        long nbSkipped = this.in.skip(this.bpsLimit >= 0L ? Math.min((long)this.getNbAllowedBytes(), l) : l);
        if (nbSkipped > 0L) {
            this.addToLimitCounter(nbSkipped);
        }
        return nbSkipped;
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
    }

    public synchronized void mark(int i) {
        this.in.mark(i);
    }

    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }
}

