/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.io.base64;

import com.mucommander.commons.io.base64.Base64Table;
import java.io.IOException;
import java.io.OutputStream;

public class Base64OutputStream
extends OutputStream {
    private OutputStream out;
    private final byte[] encodingTable;
    private final byte paddingChar;
    private byte[] byteAcc = new byte[2];
    private int nbBytesWaiting;
    private boolean insertLineBreaks;
    private int lineLength;

    public Base64OutputStream(OutputStream out, boolean insertLineBreaks) {
        this(out, insertLineBreaks, Base64Table.STANDARD_TABLE);
    }

    public Base64OutputStream(OutputStream out, boolean insertLineBreaks, Base64Table table) {
        this.out = out;
        this.insertLineBreaks = insertLineBreaks;
        this.encodingTable = table.getEncodingTable();
        this.paddingChar = table.getPaddingChar();
    }

    public void writePadding() throws IOException {
        if (this.nbBytesWaiting == 0) {
            return;
        }
        if (this.nbBytesWaiting == 2) {
            this.out.write(this.encodingTable[(byte)((this.byteAcc[0] & 0xFC) >> 2)]);
            this.out.write(this.encodingTable[(byte)((this.byteAcc[0] & 3) << 4 | (this.byteAcc[1] & 0xF0) >> 4)]);
            this.out.write(this.encodingTable[(byte)((this.byteAcc[1] & 0xF) << 2)]);
            this.out.write(this.paddingChar);
        } else if (this.nbBytesWaiting == 1) {
            this.out.write(this.encodingTable[(byte)((this.byteAcc[0] & 0xFC) >> 2)]);
            this.out.write(this.encodingTable[(byte)((this.byteAcc[0] & 3) << 4)]);
            this.out.write(this.paddingChar);
            this.out.write(this.paddingChar);
        }
        this.nbBytesWaiting = 0;
    }

    public void write(int i) throws IOException {
        if (this.nbBytesWaiting == 2) {
            this.out.write(this.encodingTable[(byte)((this.byteAcc[0] & 0xFC) >> 2)]);
            this.out.write(this.encodingTable[(byte)((this.byteAcc[0] & 3) << 4 | (this.byteAcc[1] & 0xF0) >> 4)]);
            this.out.write(this.encodingTable[(byte)((this.byteAcc[1] & 0xF) << 2 | (i & 0xC0) >> 6)]);
            this.out.write(this.encodingTable[(byte)(i & 0x3F)]);
            this.nbBytesWaiting = 0;
            if (this.insertLineBreaks && (this.lineLength += 4) >= 76) {
                this.out.write(13);
                this.out.write(10);
                this.lineLength = 0;
            }
        } else {
            this.byteAcc[this.nbBytesWaiting++] = (byte)i;
        }
    }

    public void close() throws IOException {
        this.writePadding();
        this.out.close();
    }
}

