/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.io.base64;

public class Base64Table {
    protected byte[] encodingTable;
    protected int[] decodingTable;
    protected byte paddingChar;
    public static final Base64Table STANDARD_TABLE = Base64Table.createTable((byte)43, (byte)47, (byte)61);
    public static final Base64Table URL_SAFE_TABLE = Base64Table.createTable((byte)45, (byte)95, (byte)46);
    public static final Base64Table FILENAME_SAFE_TABLE = Base64Table.createTable((byte)43, (byte)45, (byte)61);
    public static final Base64Table REGEXP_SAFE_TABLE = Base64Table.createTable((byte)33, (byte)45, (byte)61);

    public static Base64Table createTable(byte char62, byte char63, byte paddingChar) throws IllegalArgumentException {
        byte[] table = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, char62, char63};
        return new Base64Table(table, paddingChar);
    }

    public Base64Table(byte[] table, byte paddingChar) throws IllegalArgumentException {
        if (table == null || table.length != 64) {
            throw new IllegalArgumentException("Base64 table is not 64 bytes long");
        }
        this.decodingTable = new int[256];
        for (int c = 0; c < 256; c = (int)((char)(c + 1))) {
            this.decodingTable[c] = -1;
        }
        int i = 0;
        while (i < 64) {
            byte val = table[i];
            if (this.decodingTable[val] != -1) {
                throw new IllegalArgumentException("Base64 table contains duplicate values");
            }
            this.decodingTable[val] = i++;
        }
        if (this.decodingTable[paddingChar] != -1) {
            throw new IllegalArgumentException("Padding char is already used in Base64 table");
        }
        this.paddingChar = paddingChar;
        this.encodingTable = new byte[64];
        System.arraycopy(table, 0, this.encodingTable, 0, 64);
    }

    byte[] getEncodingTable() {
        return this.encodingTable;
    }

    int[] getDecodingTable() {
        return this.decodingTable;
    }

    public byte getPaddingChar() {
        return this.paddingChar;
    }
}

