/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.io.bom;

import com.mucommander.commons.io.bom.BOMConstants;
import java.nio.charset.Charset;

public class BOM {
    private byte[] sig;
    private String encoding;
    private String[] aliases;

    BOM(byte[] signature, String encoding, String[] aliases) {
        this.sig = signature;
        this.encoding = encoding;
        this.aliases = aliases;
    }

    public byte[] getSignature() {
        return this.sig;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public boolean sigStartsWith(byte[] bytes) {
        int bytesLen = bytes.length;
        if (bytesLen > this.sig.length) {
            return false;
        }
        for (int i = 0; i < bytesLen; ++i) {
            if (bytes[i] == this.sig[i]) continue;
            return false;
        }
        return true;
    }

    public boolean sigEquals(byte[] bytes) {
        return bytes.length == this.sig.length && this.sigStartsWith(bytes);
    }

    public static BOM getInstance(String encoding) {
        if (!Charset.isSupported(encoding)) {
            return null;
        }
        Charset charset = Charset.forName(encoding);
        encoding = charset.name();
        for (int i = 0; i < BOMConstants.SUPPORTED_BOMS.length; ++i) {
            String[] aliases;
            if (BOMConstants.SUPPORTED_BOMS[i].getEncoding().equalsIgnoreCase(encoding)) {
                return BOMConstants.SUPPORTED_BOMS[i];
            }
            for (String alias : aliases = BOMConstants.SUPPORTED_BOMS[i].getAliases()) {
                if (!alias.equalsIgnoreCase(encoding)) continue;
                return BOMConstants.SUPPORTED_BOMS[i];
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        return o instanceof BOM && ((BOM)o).sigEquals(this.sig);
    }

    public String toString() {
        StringBuilder out = new StringBuilder(super.toString());
        out.append(", signature=");
        for (int i = 0; i < this.sig.length; ++i) {
            out.append(0xFF & this.sig[i]);
            out.append(i == this.sig.length - 1 ? "}" : ", ");
        }
        out.append(", encoding=");
        out.append(this.encoding);
        return out.toString();
    }
}

