/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.io.security;

import java.security.MessageDigest;
import java.util.zip.Checksum;

public class ChecksumMessageDigest
extends MessageDigest {
    private Checksum checksum;

    public ChecksumMessageDigest(Checksum checksum, String algorithm) {
        super(algorithm);
        this.checksum = checksum;
    }

    protected void engineReset() {
        this.checksum.reset();
    }

    protected void engineUpdate(byte input) {
        this.checksum.update(input);
    }

    protected void engineUpdate(byte[] input, int offset, int len) {
        this.checksum.update(input, offset, len);
    }

    protected byte[] engineDigest() {
        long crcLong = this.checksum.getValue();
        byte[] crcBytes = new byte[]{(byte)(crcLong >> 24 & 0xFFL), (byte)(crcLong >> 16 & 0xFFL), (byte)(crcLong >> 8 & 0xFFL), (byte)(crcLong & 0xFFL)};
        return crcBytes;
    }
}

