/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.runtime;

import com.mucommander.commons.runtime.OsFamilies;
import com.mucommander.commons.runtime.RuntimeProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsFamily
extends RuntimeProperty
implements OsFamilies {
    private static final Logger LOGGER = LoggerFactory.getLogger(OsFamily.class);
    private static OsFamily currentValue;

    protected OsFamily(String stringRepresentation) {
        super(stringRepresentation);
    }

    public static void init() {
        if (currentValue == null) {
            currentValue = OsFamily.parseSystemProperty(OsFamily.getRawSystemProperty());
            LOGGER.info("Current OS family: {}", currentValue);
        }
    }

    public static OsFamily getCurrent() {
        if (currentValue == null) {
            OsFamily.init();
        }
        return currentValue;
    }

    public boolean isUnixBased() {
        return this == MAC_OS_X || this == LINUX || this == SOLARIS || this == FREEBSD || this == AIX || this == HP_UX || this == UNKNOWN_OS_FAMILY;
    }

    public static String getRawSystemProperty() {
        return System.getProperty("os.name");
    }

    static OsFamily parseSystemProperty(String osNameProp) {
        OsFamily osFamily = osNameProp.startsWith("Windows") ? WINDOWS : (osNameProp.startsWith("Mac OS X") ? MAC_OS_X : (osNameProp.startsWith("OS/2") ? OS_2 : (osNameProp.startsWith("Linux") ? LINUX : (osNameProp.startsWith("Solaris") || osNameProp.startsWith("SunOS") ? SOLARIS : (osNameProp.startsWith("FreeBSD") ? FREEBSD : (osNameProp.startsWith("AIX") ? AIX : (osNameProp.startsWith("HP-UX") ? HP_UX : (osNameProp.startsWith("OpenVMS") ? OPENVMS : UNKNOWN_OS_FAMILY))))))));
        return osFamily;
    }

    protected RuntimeProperty getCurrentValue() {
        return OsFamily.getCurrent();
    }
}

