/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.runtime;

import com.mucommander.commons.runtime.ComparableRuntimeProperty;
import com.mucommander.commons.runtime.OsFamilies;
import com.mucommander.commons.runtime.OsFamily;
import com.mucommander.commons.runtime.OsVersions;
import com.mucommander.commons.runtime.RuntimeProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsVersion
extends ComparableRuntimeProperty
implements OsVersions {
    private static final Logger LOGGER = LoggerFactory.getLogger(OsVersion.class);
    private static OsVersion currentValue;

    protected OsVersion(String stringRepresentation, int intValue) {
        super(stringRepresentation, intValue);
    }

    public static void init() {
        if (currentValue == null) {
            currentValue = OsVersion.parseSystemProperty(OsVersion.getRawSystemProperty(), OsFamily.getRawSystemProperty(), OsFamily.getCurrent());
            LOGGER.info("Current OS version: {}", currentValue);
        }
    }

    public static OsVersion getCurrent() {
        if (currentValue == null) {
            OsVersion.init();
        }
        return currentValue;
    }

    public static String getRawSystemProperty() {
        return System.getProperty("os.version");
    }

    static OsVersion parseSystemProperty(String osVersionProp, String osNameProp, OsFamily osFamily) {
        OsVersion osVersion = osFamily == OsFamilies.WINDOWS ? (osNameProp.equals("Windows 95") ? WINDOWS_95 : (osNameProp.equals("Windows 98") ? WINDOWS_98 : (osNameProp.equals("Windows Me") ? WINDOWS_ME : (osNameProp.equals("Windows NT") ? WINDOWS_NT : (osNameProp.equals("Windows 2000") ? WINDOWS_2000 : (osNameProp.equals("Windows XP") ? WINDOWS_XP : (osNameProp.equals("Windows 2003") ? WINDOWS_2003 : (osNameProp.equals("Windows Vista") ? WINDOWS_VISTA : (osNameProp.equals("Windows 7") ? WINDOWS_7 : WINDOWS_7))))))))) : (osFamily == OsFamilies.MAC_OS_X ? (osVersionProp.startsWith("10.7") ? MAC_OS_X_10_7 : (osVersionProp.startsWith("10.6") ? MAC_OS_X_10_6 : (osVersionProp.startsWith("10.5") ? MAC_OS_X_10_5 : (osVersionProp.startsWith("10.4") ? MAC_OS_X_10_4 : (osVersionProp.startsWith("10.3") ? MAC_OS_X_10_3 : (osVersionProp.startsWith("10.2") ? MAC_OS_X_10_2 : (osVersionProp.startsWith("10.1") ? MAC_OS_X_10_1 : (osVersionProp.startsWith("10.0") ? MAC_OS_X_10_0 : MAC_OS_X_10_7)))))))) : OsVersions.UNKNOWN_VERSION);
        return osVersion;
    }

    protected RuntimeProperty getCurrentValue() {
        return OsVersion.getCurrent();
    }
}

