/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.conf;

import com.mucommander.PlatformManager;
import com.mucommander.commons.conf.ConfigurationSource;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.io.backup.BackupInputStream;
import com.mucommander.io.backup.BackupOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;

abstract class MuConfigurationFile
implements ConfigurationSource {
    private AbstractFile configurationFile;
    private final String DEFAULT_CONFIGURATION_FILE_NAME;

    public MuConfigurationFile(String path, String defaultFilename) throws FileNotFoundException {
        this.DEFAULT_CONFIGURATION_FILE_NAME = defaultFilename;
        if (path != null) {
            this.setConfigurationFile(path);
        }
    }

    private synchronized AbstractFile getConfigurationFile() throws IOException {
        if (this.configurationFile == null) {
            return PlatformManager.getPreferencesFolder().getChild(this.DEFAULT_CONFIGURATION_FILE_NAME);
        }
        return this.configurationFile;
    }

    private synchronized void setConfigurationFile(String path) throws FileNotFoundException {
        AbstractFile file = FileFactory.getFile(path);
        if (file == null) {
            this.setConfigurationFile(new File(path));
        } else {
            this.setConfigurationFile(file);
        }
    }

    private synchronized void setConfigurationFile(File file) throws FileNotFoundException {
        this.setConfigurationFile(FileFactory.getFile(file.getAbsolutePath()));
    }

    private synchronized void setConfigurationFile(AbstractFile file) throws FileNotFoundException {
        if (file.isBrowsable()) {
            throw new FileNotFoundException("Not a valid file: " + file.getAbsolutePath());
        }
        this.configurationFile = file;
    }

    public synchronized Reader getReader() throws IOException {
        return new InputStreamReader((InputStream)new BackupInputStream(this.getConfigurationFile()), Charset.forName("utf-8"));
    }

    public synchronized Writer getWriter() throws IOException {
        return new OutputStreamWriter((OutputStream)new BackupOutputStream(this.getConfigurationFile()), Charset.forName("utf-8"));
    }

    public boolean isExists() throws IOException {
        return this.getConfigurationFile().exists();
    }
}

