/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.desktop;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.runtime.JavaVersion;
import com.mucommander.desktop.AbstractTrash;
import com.mucommander.desktop.CommandBrowse;
import com.mucommander.desktop.CommandOpen;
import com.mucommander.desktop.CommandOpenInFileManager;
import com.mucommander.desktop.DefaultDesktopAdapter;
import com.mucommander.desktop.DesktopAdapter;
import com.mucommander.desktop.DesktopInitialisationException;
import com.mucommander.desktop.DesktopOperation;
import com.mucommander.desktop.InternalBrowse;
import com.mucommander.desktop.InternalOpen;
import com.mucommander.desktop.TrashProvider;
import com.mucommander.desktop.gnome.ConfiguredGnomeDesktopAdapter;
import com.mucommander.desktop.gnome.GuessedGnomeDesktopAdapter;
import com.mucommander.desktop.kde.ConfiguredKde3DesktopAdapter;
import com.mucommander.desktop.kde.ConfiguredKde4DesktopAdapter;
import com.mucommander.desktop.kde.GuessedKde3DesktopAdapter;
import com.mucommander.desktop.kde.GuessedKde4DesktopAdapter;
import com.mucommander.desktop.openvms.OpenVMSDesktopAdapter;
import com.mucommander.desktop.osx.OSXDesktopAdapter;
import com.mucommander.desktop.windows.Win9xDesktopAdapter;
import com.mucommander.desktop.windows.WinNtDesktopAdapter;
import com.mucommander.desktop.xfce.GuessedXfceDesktopAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DesktopManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DesktopManager.class);
    private static Map<String, List<DesktopOperation>>[] operations;
    private static Vector<DesktopAdapter> desktops;
    private static DesktopAdapter desktop;
    private static TrashProvider trashProvider;

    private DesktopManager() {
    }

    public static void init(boolean install) throws DesktopInitialisationException {
        for (int i = desktops.size() - 1; i >= 0; --i) {
            DesktopAdapter current = desktops.elementAt(i);
            if (!current.isAvailable()) continue;
            desktop = current;
            LOGGER.debug("Using desktop: " + desktop);
            desktop.init(install);
            return;
        }
    }

    private static void checkInit() {
        if (desktop == null) {
            desktop = new DefaultDesktopAdapter();
        }
    }

    public static void registerAdapter(DesktopAdapter adapter) {
        desktops.add(adapter);
    }

    private static void innerRegisterOperation(String type, int priority, DesktopOperation operation) {
        List<DesktopOperation> container;
        if (operations[priority] == null) {
            DesktopManager.operations[priority] = new Hashtable<String, List<DesktopOperation>>();
        }
        if ((container = operations[priority].get(type)) == null) {
            container = new Vector<DesktopOperation>();
            operations[priority].put(type, container);
        }
        container.add(operation);
    }

    private static List<DesktopOperation> getOperations(String type, int priority) {
        if (operations[priority] == null) {
            return null;
        }
        return operations[priority].get(type);
    }

    private static DesktopOperation getAvailableOperation(String type, int priority) {
        List<DesktopOperation> container = DesktopManager.getOperations(type, priority);
        if (container != null) {
            for (int i = container.size() - 1; i >= 0; --i) {
                DesktopOperation operation = container.get(i);
                if (!operation.isAvailable()) continue;
                return operation;
            }
        }
        return null;
    }

    private static DesktopOperation getSupportedOperation(String type, int priority, Object[] target) {
        List<DesktopOperation> container = DesktopManager.getOperations(type, priority);
        if (container != null) {
            for (int i = container.size() - 1; i >= 0; --i) {
                DesktopOperation operation = container.get(i);
                if (!operation.canExecute(target)) continue;
                return operation;
            }
        }
        return null;
    }

    private static DesktopOperation getSupportedOperation(String type, Object[] target) {
        DesktopOperation operation = DesktopManager.getSupportedOperation(type, 0, target);
        if (operation != null) {
            return operation;
        }
        operation = DesktopManager.getSupportedOperation(type, 1, target);
        if (operation != null) {
            return operation;
        }
        operation = DesktopManager.getSupportedOperation(type, 2, target);
        if (operation != null) {
            return operation;
        }
        return null;
    }

    private static DesktopOperation getAvailableOperation(String type) {
        DesktopOperation operation = DesktopManager.getAvailableOperation(type, 0);
        if (operation != null) {
            return operation;
        }
        operation = DesktopManager.getAvailableOperation(type, 1);
        if (operation != null) {
            return operation;
        }
        operation = DesktopManager.getAvailableOperation(type, 2);
        if (operation != null) {
            return operation;
        }
        return null;
    }

    public static boolean isOperationAvailable(String type) {
        return DesktopManager.getAvailableOperation(type) != null;
    }

    public static boolean isOperationSupported(String type, Object[] target) {
        return DesktopManager.getSupportedOperation(type, target) != null;
    }

    public static void executeOperation(String type, Object[] target) throws IOException, UnsupportedOperationException {
        DesktopOperation operation = DesktopManager.getSupportedOperation(type, target);
        if (operation == null) {
            throw new UnsupportedOperationException();
        }
        operation.execute(target);
    }

    public static boolean canBrowse() {
        return DesktopManager.isOperationAvailable("browse");
    }

    public static void browse(URL url) throws IOException, UnsupportedOperationException {
        DesktopManager.executeOperation("browse", new Object[]{url});
    }

    public static void open(AbstractFile file) throws IOException, UnsupportedOperationException {
        DesktopManager.executeOperation("open", new Object[]{file});
    }

    public static boolean canOpenInFileManager() {
        return DesktopManager.isOperationAvailable("openFM");
    }

    public static boolean canOpenInFileManager(AbstractFile file) {
        return DesktopManager.isOperationSupported("openFM", new Object[]{file});
    }

    public static void openInFileManager(AbstractFile file) throws IOException, UnsupportedOperationException {
        DesktopManager.executeOperation("openFM", new Object[]{file});
    }

    private static String getFileManagerName(DesktopOperation operation) throws UnsupportedOperationException {
        if (operation == null) {
            throw new UnsupportedOperationException();
        }
        return operation.getName();
    }

    public static String getFileManagerName() throws UnsupportedOperationException {
        return DesktopManager.getFileManagerName(DesktopManager.getAvailableOperation("openFM"));
    }

    public static AbstractTrash getTrash() {
        TrashProvider provider = DesktopManager.getTrashProvider();
        if (provider == null) {
            return null;
        }
        return provider.getTrash();
    }

    public static TrashProvider getTrashProvider() {
        return trashProvider;
    }

    public static void setTrashProvider(TrashProvider provider) {
        trashProvider = provider;
    }

    public static boolean isLeftMouseButton(MouseEvent e) {
        DesktopManager.checkInit();
        return desktop.isLeftMouseButton(e);
    }

    public static boolean isRightMouseButton(MouseEvent e) {
        DesktopManager.checkInit();
        return desktop.isRightMouseButton(e);
    }

    public static boolean isMiddleMouseButton(MouseEvent e) {
        DesktopManager.checkInit();
        return desktop.isMiddleMouseButton(e);
    }

    public static int getMultiClickInterval() {
        DesktopManager.checkInit();
        return desktop.getMultiClickInterval();
    }

    public static String getDefaultShell() {
        DesktopManager.checkInit();
        return desktop.getDefaultShell();
    }

    public static boolean isApplication(AbstractFile file) {
        return desktop.isApplication(file);
    }

    static {
        desktops = new Vector();
        DesktopManager.registerAdapter(new DefaultDesktopAdapter());
        DesktopManager.registerAdapter(new GuessedXfceDesktopAdapter());
        DesktopManager.registerAdapter(new GuessedKde3DesktopAdapter());
        DesktopManager.registerAdapter(new GuessedKde4DesktopAdapter());
        DesktopManager.registerAdapter(new GuessedGnomeDesktopAdapter());
        DesktopManager.registerAdapter(new ConfiguredKde3DesktopAdapter());
        DesktopManager.registerAdapter(new ConfiguredKde4DesktopAdapter());
        DesktopManager.registerAdapter(new ConfiguredGnomeDesktopAdapter());
        DesktopManager.registerAdapter(new OpenVMSDesktopAdapter());
        DesktopManager.registerAdapter(new OSXDesktopAdapter());
        DesktopManager.registerAdapter(new Win9xDesktopAdapter());
        DesktopManager.registerAdapter(new WinNtDesktopAdapter());
        operations = new Hashtable[3];
        if (JavaVersion.JAVA_1_6.isCurrentOrHigher()) {
            DesktopManager.innerRegisterOperation("open", 0, new InternalOpen());
            DesktopManager.innerRegisterOperation("browse", 0, new InternalBrowse());
        }
        DesktopManager.innerRegisterOperation("browse", 0, new CommandBrowse());
        DesktopManager.innerRegisterOperation("openFM", 0, new CommandOpenInFileManager());
        DesktopManager.innerRegisterOperation("open", 0, new CommandOpen(false));
        DesktopManager.innerRegisterOperation("open", 2, new CommandOpen(true));
    }
}

