/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.desktop;

import com.mucommander.desktop.UrlOperation;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;

class InternalBrowse
extends UrlOperation {
    private Desktop desktop;
    private boolean initialized = false;

    private Desktop getDesktop() {
        if (!this.initialized) {
            if (Desktop.isDesktopSupported()) {
                this.desktop = Desktop.getDesktop();
            }
            this.initialized = true;
        }
        return this.desktop;
    }

    public boolean isAvailable() {
        return this.getDesktop() != null && this.getDesktop().isSupported(Desktop.Action.BROWSE);
    }

    public void execute(URL url) throws IOException {
        if (this.isAvailable()) {
            try {
                this.getDesktop().browse(url.toURI());
            }
            catch (URISyntaxException e) {
                throw new IOException(e.getMessage());
            }
        }
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return "java.awt.Desktop open URL";
    }
}

