/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.desktop;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.file.impl.local.LocalFile;
import com.mucommander.commons.file.impl.local.SpecialWindowsLocation;
import com.mucommander.desktop.DesktopOperation;
import java.io.File;
import java.io.IOException;

public abstract class LocalFileOperation
implements DesktopOperation {
    public abstract boolean isAvailable();

    public abstract void execute(AbstractFile var1) throws IOException, UnsupportedOperationException;

    public boolean canExecute(AbstractFile file) {
        return this.isAvailable();
    }

    public boolean canExecute(Object[] target) {
        AbstractFile file = this.extractTarget(target);
        if (file != null) {
            return this.canExecute(file);
        }
        return false;
    }

    public void execute(Object[] target) throws IOException, UnsupportedOperationException {
        AbstractFile file = this.extractTarget(target);
        if (file == null) {
            throw new UnsupportedOperationException();
        }
        this.execute(file);
    }

    protected AbstractFile extractTarget(Object[] objectArray) {
        if (objectArray.length != 1) {
            return null;
        }
        if (objectArray[0] instanceof File) {
            return FileFactory.getFile(((File)objectArray[0]).getAbsolutePath());
        }
        if (objectArray[0] instanceof SpecialWindowsLocation) {
            return (AbstractFile)objectArray[0];
        }
        if (objectArray[0] instanceof AbstractFile && ((AbstractFile)objectArray[0]).hasAncestor(LocalFile.class)) {
            return (AbstractFile)objectArray[0];
        }
        if (objectArray[0] instanceof String) {
            return FileFactory.getFile((String)objectArray[0]);
        }
        return null;
    }
}

