/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.desktop;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.desktop.AbstractTrash;
import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.InformationDialog;
import com.mucommander.ui.main.WindowManager;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QueuedTrash
extends AbstractTrash {
    private static final List<AbstractFile> queuedFiles = new Vector<AbstractFile>();
    protected static final Object moveToTrashLock = new Object();
    protected static Thread moveToTrashThread;

    protected abstract boolean moveToTrash(List<AbstractFile> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean moveToTrash(AbstractFile file) {
        if (!this.canMoveToTrash(file)) {
            return false;
        }
        Object object = moveToTrashLock;
        synchronized (object) {
            queuedFiles.add(file);
            if (moveToTrashThread == null) {
                moveToTrashThread = new MoveToTrashThread();
                moveToTrashThread.start();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForPendingOperations() {
        Object object = moveToTrashLock;
        synchronized (object) {
            if (moveToTrashThread != null) {
                try {
                    moveToTrashLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private class MoveToTrashThread
    extends Thread {
        private MoveToTrashThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int queueSize;
            do {
                queueSize = queuedFiles.size();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (queueSize != queuedFiles.size());
            Object object = moveToTrashLock;
            synchronized (object) {
                if (!QueuedTrash.this.moveToTrash(queuedFiles)) {
                    InformationDialog.showErrorDialog(WindowManager.getCurrentMainFrame(), Translator.get("delete_dialog.move_to_trash.option", new String[0]), Translator.get("delete_dialog.move_to_trash.failed", new String[0]));
                }
                queuedFiles.clear();
                moveToTrashLock.notify();
                moveToTrashThread = null;
            }
        }
    }
}

