/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.desktop.kde;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KdeConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(KdeConfig.class);
    private static String CONFIG_COMMAND = "kreadconfig";

    public static String getValue(String key) throws IOException {
        BufferedReader br = null;
        try {
            Process process = Runtime.getRuntime().exec(CONFIG_COMMAND + " --key " + key);
            br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = br.readLine();
            LOGGER.debug(CONFIG_COMMAND + " returned '" + line + "' for " + key);
            if (line == null || (line = line.trim()).equals("")) {
                String string = null;
                return string;
            }
            String string = line;
            return string;
        }
        catch (IOException e) {
            LOGGER.debug("Error while retrieving value for " + key, e);
            throw e;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

