/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.desktop.kde;

import com.mucommander.command.Command;
import com.mucommander.command.CommandException;
import com.mucommander.command.CommandManager;
import com.mucommander.desktop.DefaultDesktopAdapter;
import com.mucommander.desktop.DesktopInitialisationException;
import com.mucommander.desktop.DesktopManager;
import com.mucommander.desktop.TrashProvider;
import com.mucommander.desktop.kde.KdeConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class KdeDesktopAdapter
extends DefaultDesktopAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(KdeDesktopAdapter.class);
    private int multiClickInterval;
    private String DOUBLE_CLICK_CONFIG_KEY = "DoubleClickInterval";

    KdeDesktopAdapter() {
    }

    public void init(boolean install) throws DesktopInitialisationException {
        DesktopManager.setTrashProvider(this.getTrashProvider());
        try {
            String execCommand = this.getBaseCommand() + " exec $f";
            CommandManager.registerDefaultCommand(new Command("open", execCommand, 1, null));
            CommandManager.registerDefaultCommand(new Command("openURL", execCommand, 1, null));
            CommandManager.registerDefaultCommand(new Command("openFM", execCommand, 1, this.getFileManagerName()));
        }
        catch (CommandException e) {
            throw new DesktopInitialisationException(e);
        }
        try {
            String value = KdeConfig.getValue(this.DOUBLE_CLICK_CONFIG_KEY);
            if (value == null) {
                this.multiClickInterval = super.getMultiClickInterval();
            }
            this.multiClickInterval = Integer.parseInt(value);
        }
        catch (Exception e) {
            LOGGER.debug("Error while retrieving double-click interval from gconftool", e);
            this.multiClickInterval = super.getMultiClickInterval();
        }
    }

    public int getMultiClickInterval() {
        return this.multiClickInterval;
    }

    protected String getConfiguredEnvVariable(String name) {
        return System.getenv(name);
    }

    protected abstract String getFileManagerName();

    protected abstract String getBaseCommand();

    protected abstract TrashProvider getTrashProvider();
}

