/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.desktop.kde;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.impl.local.LocalFile;
import com.mucommander.desktop.QueuedTrash;
import com.mucommander.process.ProcessRunner;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class KdeTrash
extends QueuedTrash {
    private static final Logger LOGGER = LoggerFactory.getLogger(KdeTrash.class);
    private String baseCommand;

    KdeTrash(String baseCommand) {
        this.baseCommand = baseCommand;
    }

    private static boolean executeAndWait(String command) {
        try {
            ProcessRunner.execute(command).waitFor();
            return true;
        }
        catch (Exception e) {
            LOGGER.debug("Caught exception", e);
            return false;
        }
    }

    private static boolean executeAndWait(String[] command) {
        try {
            ProcessRunner.execute(command).waitFor();
            return true;
        }
        catch (Exception e) {
            LOGGER.debug("Caught exception", e);
            return false;
        }
    }

    @Override
    public boolean canMoveToTrash(AbstractFile file) {
        return file.getTopAncestor() instanceof LocalFile;
    }

    @Override
    public boolean canEmpty() {
        return true;
    }

    @Override
    public boolean empty() {
        return KdeTrash.executeAndWait("ktrash --empty");
    }

    @Override
    public boolean isTrashFile(AbstractFile file) {
        return file.getTopAncestor() instanceof LocalFile && file.getAbsolutePath(true).indexOf("/.local/share/Trash/") != -1;
    }

    @Override
    public int getItemCount() {
        return -1;
    }

    @Override
    public void open() {
        KdeTrash.executeAndWait(this.baseCommand + " exec trash:/");
    }

    @Override
    public boolean canOpen() {
        return true;
    }

    @Override
    protected boolean moveToTrash(List<AbstractFile> queuedFiles) {
        int nbFiles = queuedFiles.size();
        String[] tokens = new String[nbFiles + 3];
        tokens[0] = this.baseCommand;
        tokens[1] = "move";
        for (int i = 0; i < nbFiles; ++i) {
            tokens[i + 2] = queuedFiles.get(i).getAbsolutePath();
        }
        tokens[nbFiles + 2] = "trash:/";
        return KdeTrash.executeAndWait(tokens);
    }
}

