/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.desktop.osx;

import com.mucommander.command.Command;
import com.mucommander.command.CommandException;
import com.mucommander.command.CommandManager;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.runtime.OsFamily;
import com.mucommander.desktop.DefaultDesktopAdapter;
import com.mucommander.desktop.DesktopInitialisationException;
import com.mucommander.desktop.DesktopManager;
import com.mucommander.desktop.osx.OSXTrashProvider;
import java.awt.event.MouseEvent;

public class OSXDesktopAdapter
extends DefaultDesktopAdapter {
    public String toString() {
        return "MAC OS X Desktop";
    }

    public boolean isAvailable() {
        return OsFamily.getCurrent().equals(OsFamily.MAC_OS_X);
    }

    public void init(boolean install) throws DesktopInitialisationException {
        DesktopManager.setTrashProvider(new OSXTrashProvider());
        try {
            CommandManager.registerDefaultCommand(new Command("open", "open $f", 1, null));
            CommandManager.registerDefaultCommand(new Command("openURL", "open $f", 1, null));
            CommandManager.registerDefaultCommand(new Command("openFM", "open -a Finder $f", 1, "Finder"));
        }
        catch (CommandException e) {
            throw new DesktopInitialisationException(e);
        }
    }

    public boolean isLeftMouseButton(MouseEvent e) {
        int modifiers = e.getModifiers();
        return (modifiers & 0x10) != 0 && !e.isControlDown();
    }

    public boolean isRightMouseButton(MouseEvent e) {
        int modifiers = e.getModifiers();
        return (modifiers & 4) != 0 || (modifiers & 0x10) != 0 && e.isControlDown();
    }

    public boolean isApplication(AbstractFile file) {
        String extension = file.getExtension();
        return extension != null && extension.equalsIgnoreCase("app") && file.isDirectory();
    }
}

