/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.desktop.windows;

import com.mucommander.command.Command;
import com.mucommander.command.CommandException;
import com.mucommander.command.CommandManager;
import com.mucommander.commons.file.filter.RegexpFilenameFilter;
import com.mucommander.commons.runtime.OsVersion;
import com.mucommander.desktop.DesktopInitialisationException;
import com.mucommander.desktop.windows.WindowsDesktopAdapter;

public class WinNtDesktopAdapter
extends WindowsDesktopAdapter {
    public String toString() {
        return "Windows NT+ Desktop";
    }

    public boolean isAvailable() {
        return super.isAvailable() && OsVersion.getCurrent().compareTo(OsVersion.WINDOWS_NT) >= 0;
    }

    public void init(boolean install) throws DesktopInitialisationException {
        super.init(install);
        try {
            CommandManager.registerDefaultCommand(new Command("open", "cmd /c start \"\" \"$f\"", 1, null));
            CommandManager.registerDefaultCommand(new Command("openURL", "cmd /c start \"\" \"$f\"", 1, null));
            CommandManager.registerDefaultCommand(new Command("openFM", "cmd /c start \"\" \"$f\"", 1, "Explorer"));
            CommandManager.registerDefaultCommand(new Command("openEXE", "cmd /c $f", 1, null));
            CommandManager.registerDefaultAssociation("openEXE", new RegexpFilenameFilter(".*\\.exe", false));
        }
        catch (CommandException e) {
            throw new DesktopInitialisationException(e);
        }
    }

    public String getDefaultShell() {
        return "cmd /c";
    }
}

