/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.extension;

import com.mucommander.PlatformManager;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.AbstractFileClassLoader;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.file.filter.ExtensionFilenameFilter;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;

public class ExtensionManager {
    private static AbstractFileClassLoader loader;
    private static AbstractFile extensionsFolder;

    private ExtensionManager() {
    }

    public static void setExtensionsFolder(File folder) throws IOException {
        ExtensionManager.setExtensionsFolder(FileFactory.getFile(folder.getAbsolutePath()));
    }

    public static void setExtensionsFolder(AbstractFile folder) throws IOException {
        if (!folder.exists()) {
            folder.mkdir();
        } else if (!folder.isBrowsable()) {
            folder = folder.getParent();
        }
        extensionsFolder = folder;
    }

    public static void setExtensionsFolder(String path) throws IOException {
        AbstractFile folder = FileFactory.getFile(path);
        if (folder == null) {
            ExtensionManager.setExtensionsFolder(new File(path));
        } else {
            ExtensionManager.setExtensionsFolder(folder);
        }
    }

    private static AbstractFile getDefaultExtensionsFolder() throws IOException {
        AbstractFile folder = PlatformManager.getPreferencesFolder().getChild("extensions");
        if (!folder.exists()) {
            folder.mkdir();
        }
        return folder;
    }

    public static AbstractFile getExtensionsFolder() throws IOException {
        if (extensionsFolder != null) {
            return extensionsFolder;
        }
        return ExtensionManager.getDefaultExtensionsFolder();
    }

    public static AbstractFile getExtensionsFile(String filename) throws IOException {
        return ExtensionManager.getExtensionsFolder().getDirectChild(filename);
    }

    public static boolean isInExtensionsPath(AbstractFile file) {
        return loader.contains(file);
    }

    public static boolean isInClasspath(AbstractFile file) {
        String path = file.getAbsolutePath();
        StringTokenizer parser = new StringTokenizer(System.getProperty("java.class.path"), System.getProperty("path.separator"));
        while (parser.hasMoreTokens()) {
            if (!parser.nextToken().equals(path)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAvailable(AbstractFile file) {
        return ExtensionManager.isInClasspath(file) || ExtensionManager.isInExtensionsPath(file);
    }

    public static boolean importLibrary(AbstractFile file, boolean force) throws IOException {
        if (ExtensionManager.isAvailable(file)) {
            return true;
        }
        AbstractFile dest = ExtensionManager.getExtensionsFile(file.getName());
        if (dest.exists()) {
            if (!force) {
                return false;
            }
            dest.delete();
        }
        file.copyTo(dest);
        ExtensionManager.addToClassPath(dest);
        return true;
    }

    public static void addToClassPath(AbstractFile file) {
        loader.addFile(file);
    }

    public static void addExtensionsToClasspath() throws IOException {
        AbstractFile[] files;
        ExtensionManager.addToClassPath(ExtensionManager.getExtensionsFolder());
        for (AbstractFile file : files = ExtensionManager.getExtensionsFolder().ls(new ExtensionFilenameFilter(".jar"))) {
            ExtensionManager.addToClassPath(file);
        }
    }

    public static ClassLoader getClassLoader() {
        return loader;
    }

    static {
        ClassLoader temp = ClassLoader.getSystemClassLoader();
        loader = temp instanceof AbstractFileClassLoader ? (AbstractFileClassLoader)temp : new AbstractFileClassLoader();
    }
}

