/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.job;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.util.FileSet;
import com.mucommander.job.FileCollisionChecker;
import com.mucommander.job.TransferFileJob;
import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.file.FileCollisionDialog;
import com.mucommander.ui.dialog.file.ProgressDialog;
import com.mucommander.ui.icon.IconManager;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.viewer.ViewerRegistrar;
import java.awt.Component;
import java.awt.Dialog;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalculateChecksumJob
extends TransferFileJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalculateChecksumJob.class);
    private AbstractFile checksumFile;
    private OutputStream checksumFileOut;
    private String baseSourcePath;
    private boolean useSfvFormat;
    private MessageDigest digest;

    public CalculateChecksumJob(ProgressDialog progressDialog, MainFrame mainFrame, FileSet files, AbstractFile checksumFile, MessageDigest digest) {
        super(progressDialog, mainFrame, files);
        this.checksumFile = checksumFile;
        this.digest = digest;
        this.useSfvFormat = digest.getAlgorithm().equalsIgnoreCase("CRC32");
        this.baseSourcePath = this.getBaseSourceFolder().getAbsolutePath(true);
    }

    protected boolean processFile(AbstractFile file, Object recurseParams) {
        if (file.isDirectory()) {
            while (true) {
                try {
                    AbstractFile[] children = file.ls();
                    for (int i = 0; i < children.length && this.getState() != 3; ++i) {
                        this.nextFile(children[i]);
                        this.processFile(children[i], null);
                    }
                    return true;
                }
                catch (IOException e) {
                    int ret = this.showErrorDialog(Translator.get("error", new String[0]), Translator.get("cannot_read_folder", file.getName()));
                    if (ret == 2) continue;
                    return false;
                }
                break;
            }
        }
        while (true) {
            InputStream in = null;
            try {
                this.digest.reset();
                in = null;
                in = this.setCurrentInputStream(file.getInputStream());
                String relativePath = file.getAbsolutePath();
                relativePath = relativePath.substring(this.baseSourcePath.length(), relativePath.length());
                String checksum = AbstractFile.calculateChecksum(in, this.digest);
                String line = this.useSfvFormat ? relativePath + " " + checksum : checksum + "  " + relativePath;
                line = line + '\n';
                in.close();
                this.checksumFileOut.write(line.getBytes("utf-8"));
                return true;
            }
            catch (IOException e) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                }
                if (this.getState() == 3 || this.wasCurrentFileSkipped()) {
                    return false;
                }
                LOGGER.debug("Caught IOException", e);
                int ret = this.showErrorDialog(Translator.get("error", new String[0]), Translator.get("error_while_transferring", file.getAbsolutePath()));
                if (ret == 2) {
                    this.getCurrentFileByteCounter().reset();
                    continue;
                }
                return false;
            }
            break;
        }
    }

    protected boolean hasFolderChanged(AbstractFile folder) {
        return folder.equalsCanonical(this.checksumFile.getParent());
    }

    protected void jobStarted() {
        int choice;
        super.jobStarted();
        int collision = FileCollisionChecker.checkForCollision(null, this.checksumFile);
        if (collision != 0 && (choice = this.waitForUserResponse(new FileCollisionDialog((Dialog)this.getProgressDialog(), (Component)this.getMainFrame(), collision, null, this.checksumFile, false, false))) != 2) {
            this.interrupt();
            return;
        }
        while (true) {
            try {
                this.checksumFileOut = this.checksumFile.getOutputStream();
            }
            catch (Exception e) {
                int choice2 = this.showErrorDialog(Translator.get("error", new String[0]), Translator.get("cannot_write_file", this.checksumFile.getName()), new String[]{CANCEL_TEXT, RETRY_TEXT}, new int[]{3, 2});
                if (choice2 == 2) continue;
                this.interrupt();
                return;
            }
            break;
        }
    }

    protected void jobCompleted() {
        super.jobCompleted();
        ViewerRegistrar.createViewerFrame(this.getMainFrame(), this.checksumFile, IconManager.getImageIcon(this.checksumFile.getIcon()).getImage());
    }

    protected void jobStopped() {
        super.jobStopped();
        if (this.checksumFileOut != null) {
            try {
                this.checksumFileOut.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

