/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.job;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileOperation;
import com.mucommander.commons.file.util.FileSet;
import com.mucommander.job.FileJob;
import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.file.ProgressDialog;
import com.mucommander.ui.main.MainFrame;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeFileAttributesJob
extends FileJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangeFileAttributesJob.class);
    private boolean recurseOnDirectories;
    private int permissions = -1;
    private long date = -1L;

    public ChangeFileAttributesJob(ProgressDialog progressDialog, MainFrame mainFrame, FileSet files, int permissions, boolean recurseOnDirectories) {
        super(progressDialog, mainFrame, files);
        this.permissions = permissions;
        this.recurseOnDirectories = recurseOnDirectories;
    }

    public ChangeFileAttributesJob(ProgressDialog progressDialog, MainFrame mainFrame, FileSet files, long date, boolean recurseOnDirectories) {
        super(progressDialog, mainFrame, files);
        this.date = date;
        this.recurseOnDirectories = recurseOnDirectories;
    }

    protected boolean processFile(AbstractFile file, Object recurseParams) {
        if (this.getState() == 3) {
            return false;
        }
        if (this.recurseOnDirectories && file.isDirectory()) {
            while (true) {
                try {
                    AbstractFile[] children = file.ls();
                    int nbChildren = children.length;
                    for (int i = 0; i < nbChildren && this.getState() != 3; ++i) {
                        this.nextFile(children[i]);
                        this.processFile(children[i], null);
                    }
                }
                catch (IOException e) {
                    int ret = this.showErrorDialog("", Translator.get("cannot_read_folder", file.getName()));
                    if (ret == 2) continue;
                    return false;
                }
                break;
            }
        }
        if (this.permissions != -1) {
            if (!file.isFileOperationSupported(FileOperation.CHANGE_PERMISSION)) {
                return false;
            }
            try {
                file.changePermissions(this.permissions);
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        if (!file.isFileOperationSupported(FileOperation.CHANGE_DATE)) {
            return false;
        }
        try {
            file.changeDate(this.date);
            return true;
        }
        catch (IOException e) {
            LOGGER.debug("failed to change the date of " + file, e);
            return false;
        }
    }

    protected boolean hasFolderChanged(AbstractFile folder) {
        return this.getBaseSourceFolder().isParentOf(folder);
    }
}

