/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.job;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.util.FileSet;
import com.mucommander.commons.io.StreamUtils;
import com.mucommander.job.AbstractCopyJob;
import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.file.ProgressDialog;
import com.mucommander.ui.main.MainFrame;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombineFilesJob
extends AbstractCopyJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(CombineFilesJob.class);
    AbstractFile destFile = null;
    private OutputStream out;
    private AbstractFile crcFile;

    public CombineFilesJob(ProgressDialog progressDialog, MainFrame mainFrame, FileSet files, AbstractFile destFile, int fileExistsAction) {
        super(progressDialog, mainFrame, files, destFile, null, fileExistsAction);
        this.errorDialogTitle = Translator.get("combine_files_dialog.error_title", new String[0]);
    }

    protected boolean hasFolderChanged(AbstractFile folder) {
        return this.baseDestFolder.isParentOf(folder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processFile(AbstractFile file, Object recurseParams) {
        if (this.destFile == null) {
            this.createDestFile(file);
            this.findCRCFile(file);
        }
        if (this.getState() == 3) {
            return false;
        }
        try {
            InputStream in = file.getInputStream();
            this.setCurrentInputStream(in);
            StreamUtils.copyStream(in, this.out);
        }
        catch (IOException e) {
            LOGGER.debug("Caught exception", e);
            this.showErrorDialog(this.errorDialogTitle, Translator.get("error_while_transferring", this.destFile.getName()), new String[]{CANCEL_TEXT}, new int[]{3});
            this.interrupt();
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeCurrentInputStream();
        }
        return true;
    }

    protected void createDestFile(AbstractFile file) {
        this.destFile = this.baseDestFolder;
        this.baseDestFolder = this.baseDestFolder.getParent();
        this.destFile = this.checkForCollision(file, this.baseDestFolder, this.destFile, false);
        if (this.destFile == null) {
            this.interrupt();
            return;
        }
        try {
            this.out = this.destFile.getOutputStream();
        }
        catch (IOException e) {
            LOGGER.debug("Caught exception", e);
            this.showErrorDialog(this.errorDialogTitle, Translator.get("error_while_transferring", this.destFile.getName()), new String[]{CANCEL_TEXT}, new int[]{3});
            this.interrupt();
        }
    }

    private void findCRCFile(AbstractFile file) {
        AbstractFile f = file.getParent();
        if (f != null) {
            try {
                this.crcFile = f.getDirectChild(file.getNameWithoutExtension() + ".sfv");
            }
            catch (IOException e) {
                LOGGER.debug("Caught exception", e);
            }
        }
    }

    protected void jobStopped() {
        super.jobStopped();
        this.closeOutputStream();
    }

    protected void jobCompleted() {
        super.jobCompleted();
        this.closeOutputStream();
        this.checkCRC();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCRC() {
        if (this.crcFile == null || !this.crcFile.exists()) {
            this.showErrorDialog(this.errorDialogTitle, Translator.get("combine_files_job.no_crc_file", new String[0]), new String[]{OK_TEXT}, new int[]{5});
            return;
        }
        InputStream crcIn = null;
        try {
            crcIn = this.crcFile.getInputStream();
            BufferedReader crcReader = new BufferedReader(new InputStreamReader(crcIn));
            String crcLine = crcReader.readLine();
            crcLine = crcLine.substring(crcLine.lastIndexOf(32) + 1).trim();
            String crcDest = this.destFile.calculateChecksum("CRC32");
            if (!crcLine.equals(crcDest)) {
                this.showErrorDialog(this.errorDialogTitle, Translator.get("combine_files_job.crc_check_failed", crcDest, crcLine), new String[]{OK_TEXT}, new int[]{5});
            } else {
                this.showErrorDialog(Translator.get("combine_files_dialog.error_title", new String[0]), Translator.get("combine_files_job.crc_ok", new String[0]), new String[]{OK_TEXT}, new int[]{5});
            }
        }
        catch (Exception e) {
            LOGGER.debug("Caught exception", e);
            this.showErrorDialog(this.errorDialogTitle, Translator.get("combine_files_job.crc_read_error", new String[0]), new String[]{CANCEL_TEXT}, new int[]{3});
        }
        finally {
            if (crcIn != null) {
                try {
                    crcIn.close();
                }
                catch (IOException e) {
                    LOGGER.debug("Caught exception", e);
                }
            }
        }
    }

    private void closeOutputStream() {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException e) {
                LOGGER.debug("Caught exception", e);
                this.showErrorDialog(this.errorDialogTitle, Translator.get("error_while_transferring", this.destFile.getName()), new String[]{CANCEL_TEXT}, new int[]{3});
            }
        }
    }
}

