/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.job;

import com.mucommander.commons.file.AbstractArchiveFile;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.AbstractRWArchiveFile;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.file.FileOperation;
import com.mucommander.commons.file.util.FileSet;
import com.mucommander.job.AbstractCopyJob;
import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.file.ProgressDialog;
import com.mucommander.ui.main.MainFrame;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveJob
extends AbstractCopyJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoveJob.class);
    protected boolean renameMode = false;

    public MoveJob(ProgressDialog progressDialog, MainFrame mainFrame, FileSet files, AbstractFile destFolder, String newName, int fileExistsAction, boolean renameMode) {
        super(progressDialog, mainFrame, files, destFolder, newName, fileExistsAction);
        this.errorDialogTitle = Translator.get("move_dialog.error_title", new String[0]);
        this.renameMode = renameMode;
    }

    protected boolean processFile(AbstractFile file, Object recurseParams) {
        if (this.getState() == 3) {
            return false;
        }
        AbstractFile destFolder = recurseParams == null ? this.baseDestFolder : (AbstractFile)recurseParams;
        boolean isFileInBaseFolder = this.files.indexOf(file) != -1;
        String originalName = file.getName();
        String destFileName = isFileInBaseFolder && this.newName != null ? this.newName : originalName;
        AbstractFile destFile = this.createDestinationFile(destFolder, destFileName);
        if (destFile == null) {
            return false;
        }
        if (file.isSymlink()) {
            while (true) {
                try {
                    file.delete();
                    return true;
                }
                catch (IOException e) {
                    LOGGER.debug("IOException caught", e);
                    int ret = this.showErrorDialog(this.errorDialogTitle, Translator.get("cannot_delete_file", file.getAbsolutePath()));
                    if (ret == 2) continue;
                    return false;
                }
                break;
            }
        }
        if ((destFile = this.checkForCollision(file, destFolder, destFile, this.renameMode)) == null) {
            return false;
        }
        if (!this.append && file.getURL().schemeEquals(destFile.getURL()) && file.isFileOperationSupported(FileOperation.RENAME)) {
            try {
                file.renameTo(destFile);
                return true;
            }
            catch (IOException e) {
                LOGGER.debug("Failed to rename " + file + " into " + destFile + " (not necessarily an error)", e);
            }
        }
        if (file.isDirectory()) {
            int ret;
            if (!destFile.exists() || !destFile.isDirectory()) {
                while (true) {
                    try {
                        destFile.mkdir();
                    }
                    catch (IOException e) {
                        ret = this.showErrorDialog(this.errorDialogTitle, Translator.get("cannot_create_folder", destFile.getAbsolutePath()));
                        if (ret == 2) continue;
                        return false;
                    }
                    break;
                }
            }
            while (true) {
                try {
                    AbstractFile[] subFiles = file.ls();
                    boolean isFolderEmpty = true;
                    for (AbstractFile subFile : subFiles) {
                        if (this.getState() == 3) {
                            return false;
                        }
                        this.nextFile(subFile);
                        if (this.processFile(subFile, destFile)) continue;
                        isFolderEmpty = false;
                    }
                    if (destFile.isFileOperationSupported(FileOperation.CHANGE_DATE)) {
                        try {
                            destFile.changeDate(file.getDate());
                        }
                        catch (IOException e) {
                            LOGGER.debug("failed to change the date of " + destFile, e);
                        }
                    }
                    if (!isFolderEmpty) {
                        return false;
                    }
                }
                catch (IOException e) {
                    ret = this.showErrorDialog(this.errorDialogTitle, Translator.get("cannot_read_folder", file.getName()));
                    if (ret == 2) continue;
                    return false;
                }
                break;
            }
            if (this.getState() == 3) {
                return false;
            }
            while (true) {
                try {
                    file.delete();
                    return true;
                }
                catch (IOException e) {
                    ret = this.showErrorDialog(this.errorDialogTitle, Translator.get("cannot_delete_folder", file.getAbsolutePath()));
                    if (ret == 2) continue;
                    return false;
                }
                break;
            }
        }
        if (this.tryCopyFile(file, destFile, this.append, this.errorDialogTitle) && this.getState() != 3) {
            while (true) {
                try {
                    file.delete();
                    return true;
                }
                catch (IOException e) {
                    LOGGER.debug("IOException caught", e);
                    int ret = this.showErrorDialog(this.errorDialogTitle, Translator.get("cannot_delete_file", file.getAbsolutePath()));
                    if (ret == 2) continue;
                    return false;
                }
                break;
            }
        }
        return false;
    }

    protected boolean hasFolderChanged(AbstractFile folder) {
        return this.getBaseSourceFolder() != null && this.getBaseSourceFolder().isParentOf(folder) || this.baseDestFolder.isParentOf(folder);
    }

    protected void jobCompleted() {
        AbstractArchiveFile destArchiveFile;
        AbstractArchiveFile sourceArchiveFile;
        super.jobCompleted();
        AbstractArchiveFile abstractArchiveFile = sourceArchiveFile = this.getBaseSourceFolder() == null ? null : this.getBaseSourceFolder().getParentArchive();
        if (sourceArchiveFile != null && sourceArchiveFile.isArchive() && sourceArchiveFile.isWritable()) {
            this.optimizeArchive((AbstractRWArchiveFile)sourceArchiveFile);
        }
        if ((destArchiveFile = this.baseDestFolder.getParentArchive()) != null && destArchiveFile.isArchive() && destArchiveFile.isWritable() && (sourceArchiveFile == null || !destArchiveFile.equalsCanonical(sourceArchiveFile))) {
            this.optimizeArchive((AbstractRWArchiveFile)destArchiveFile);
        }
        if (this.files.size() == 1 && this.newName != null && this.baseDestFolder.equalsCanonical(((AbstractFile)this.files.elementAt(0)).getParent())) {
            this.selectFileWhenFinished(FileFactory.getFile(this.baseDestFolder.getAbsolutePath(true) + this.newName));
        }
    }

    public String getStatusString() {
        if (this.isCheckingIntegrity()) {
            return super.getStatusString();
        }
        if (this.isOptimizingArchive) {
            return Translator.get("optimizing_archive", this.archiveToOptimize.getName());
        }
        return Translator.get("move_dialog.moving_file", this.getCurrentFilename());
    }
}

