/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.job;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.util.FileSet;
import com.mucommander.job.FileJob;
import com.mucommander.ui.main.MainFrame;
import java.io.IOException;

public class PropertiesJob
extends FileJob {
    private int nbFolders;
    private int nbFilesRecurse;
    private long totalBytes;

    public PropertiesJob(FileSet files, MainFrame mainFrame) {
        super(mainFrame, files);
        this.setAutoUnmark(false);
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public int getNbFolders() {
        return this.nbFolders;
    }

    public int getNbFilesRecurse() {
        return this.nbFilesRecurse;
    }

    protected boolean processFile(AbstractFile file, Object recurseParams) {
        if (this.getState() == 3) {
            return false;
        }
        if (file.isDirectory() && !file.isSymlink()) {
            ++this.nbFolders;
            try {
                AbstractFile[] subFiles = file.ls();
                for (int i = 0; i < subFiles.length && this.getState() != 3; ++i) {
                    this.nextFile(subFiles[i]);
                    this.processFile(subFiles[i], null);
                }
            }
            catch (IOException e) {}
        } else {
            ++this.nbFilesRecurse;
            long fileSize = file.getSize();
            if (fileSize > 0L) {
                this.totalBytes += fileSize;
            }
        }
        return true;
    }

    protected boolean hasFolderChanged(AbstractFile folder) {
        return false;
    }
}

