/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.job;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.file.filter.AttributeFileFilter;
import com.mucommander.commons.file.filter.EqualsFilenameFilter;
import com.mucommander.commons.file.filter.ExtensionFilenameFilter;
import com.mucommander.commons.file.filter.OrFileFilter;
import com.mucommander.commons.file.util.FileSet;
import com.mucommander.commons.file.util.ResourceLoader;
import com.mucommander.commons.runtime.OsFamilies;
import com.mucommander.desktop.DesktopManager;
import com.mucommander.job.CopyJob;
import com.mucommander.process.ProcessRunner;
import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.file.ProgressDialog;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.main.WindowManager;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfUpdateJob
extends CopyJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelfUpdateJob.class);
    private AbstractFile destJar;
    private AbstractFile tempDestJar;
    private ClassLoader classLoader;
    private OrFileFilter directoryOrClassFileFilter;
    private boolean loadingClasses = true;

    public SelfUpdateJob(ProgressDialog progressDialog, MainFrame mainFrame, AbstractFile remoteJarFile) {
        this(progressDialog, mainFrame, new FileSet(remoteJarFile.getParent(), remoteJarFile), SelfUpdateJob.getDestJarFile());
    }

    private SelfUpdateJob(ProgressDialog progressDialog, MainFrame mainFrame, FileSet files, AbstractFile destJar) {
        this(progressDialog, mainFrame, files, destJar, SelfUpdateJob.getTempDestJar(destJar));
    }

    private SelfUpdateJob(ProgressDialog progressDialog, MainFrame mainFrame, FileSet files, AbstractFile destJar, AbstractFile tempDestJar) {
        super(progressDialog, mainFrame, files, tempDestJar.getParent(), tempDestJar.getName(), 1, 2);
        this.destJar = destJar;
        this.tempDestJar = tempDestJar;
        this.classLoader = this.getClass().getClassLoader();
        this.directoryOrClassFileFilter = new OrFileFilter(new AttributeFileFilter(0), new ExtensionFilenameFilter(".class"));
    }

    private static AbstractFile getTempDestJar(AbstractFile destJar) {
        try {
            return SelfUpdateJob.createTemporaryFolder().getChild(destJar.getName());
        }
        catch (IOException e) {
            return destJar;
        }
    }

    private static AbstractFile createTemporaryFolder() {
        AbstractFile tempFolder;
        try {
            tempFolder = FileFactory.getTemporaryFile("mucomander-self-update", true);
            tempFolder.mkdir();
        }
        catch (IOException e) {
            tempFolder = FileFactory.getTemporaryFolder();
        }
        return tempFolder;
    }

    private static AbstractFile getDestJarFile() {
        return ResourceLoader.getRootPackageAsFile(SelfUpdateJob.class);
    }

    private void loadClassRecurse(AbstractFile file) throws Exception {
        if (file.isBrowsable()) {
            AbstractFile[] children;
            for (AbstractFile child : children = file.ls(this.directoryOrClassFileFilter)) {
                this.loadClassRecurse(child);
            }
        } else {
            String classname = file.getAbsolutePath(false);
            classname = classname.substring(this.destJar.getAbsolutePath(true).length(), classname.length() - 6);
            classname = classname.replace(this.destJar.getSeparator(), ".");
            try {
                this.classLoader.loadClass(classname);
                LOGGER.trace("Loaded class " + classname);
            }
            catch (NoClassDefFoundError e) {
                LOGGER.debug("Caught an error while loading class " + classname, e);
            }
        }
    }

    public String getStatusString() {
        if (this.loadingClasses) {
            return Translator.get("version_dialog.preparing_for_update", new String[0]);
        }
        return super.getStatusString();
    }

    protected void jobStarted() {
        super.jobStarted();
        try {
            this.loadClassRecurse(this.destJar);
            this.loadingClasses = false;
        }
        catch (Exception e) {
            LOGGER.debug("Caught exception", e);
            this.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void jobCompleted() {
        try {
            AbstractFile parent;
            if (OsFamilies.MAC_OS_X.isCurrent()) {
                parent = this.destJar.getParent();
                if (parent.getName().equals("Java") && (parent = parent.getParent()) != null && parent.getName().equals("Resources") && (parent = parent.getParent()) != null && parent.getName().equals("Contents") && (parent = parent.getParent()) != null && "app".equals(parent.getExtension())) {
                    String appPath = parent.getAbsolutePath();
                    LOGGER.debug("Opening " + appPath);
                    ProcessRunner.execute(new String[]{"/bin/sh", "-c", "open -W " + appPath + " && open " + appPath});
                    return;
                }
            } else {
                EqualsFilenameFilter launcherFilter;
                parent = this.destJar.getParent();
                AbstractFile[] launcherFile = parent.ls(launcherFilter = OsFamilies.WINDOWS.isCurrent() ? new EqualsFilenameFilter("muCommander.exe", false) : new EqualsFilenameFilter("mucommander.sh", false));
                if (launcherFile != null && launcherFile.length == 1) {
                    DesktopManager.open(launcherFile[0]);
                    return;
                }
            }
            ProcessRunner.execute(new String[]{"java", "-jar", this.destJar.getAbsolutePath()});
        }
        catch (IOException e) {
            LOGGER.debug("Caught exception", e);
        }
        finally {
            WindowManager.quit();
        }
    }

    protected boolean processFile(AbstractFile file, Object recurseParams) {
        if (!super.processFile(file, recurseParams)) {
            return false;
        }
        try {
            this.tempDestJar.moveTo(this.destJar);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

