/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.job;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.MimeTypes;
import com.mucommander.commons.file.util.FileSet;
import com.mucommander.commons.io.StreamUtils;
import com.mucommander.commons.io.base64.Base64OutputStream;
import com.mucommander.conf.MuConfigurations;
import com.mucommander.conf.MuPreference;
import com.mucommander.job.TransferFileJob;
import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.file.ProgressDialog;
import com.mucommander.ui.main.MainFrame;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendMailJob
extends TransferFileJob {
    private boolean connectedToMailServer;
    private String errorDialogTitle;
    private String recipientString;
    private String mailSubject;
    private String mailBody;
    private String mailServer;
    private String fromName;
    private String fromAddress;
    private String boundary = "mucommander" + System.currentTimeMillis();
    private BufferedReader in;
    private OutputStream out;
    private Base64OutputStream out64;
    private Socket socket;
    private static final String CLOSE_TEXT = Translator.get("close", new String[0]);

    public SendMailJob(ProgressDialog progressDialog, MainFrame mainFrame, FileSet filesToSend, String recipientString, String mailSubject, String mailBody) {
        super(progressDialog, mainFrame, filesToSend);
        this.recipientString = recipientString;
        this.mailSubject = mailSubject;
        this.mailBody = mailBody + "\n\n" + "Sent by muCommander - http://www.mucommander.com\n";
        this.mailServer = MuConfigurations.getPreferences().getVariable(MuPreference.SMTP_SERVER);
        this.fromName = MuConfigurations.getPreferences().getVariable(MuPreference.MAIL_SENDER_NAME);
        this.fromAddress = MuConfigurations.getPreferences().getVariable(MuPreference.MAIL_SENDER_ADDRESS);
        this.errorDialogTitle = Translator.get("email_dialog.error_title", new String[0]);
    }

    public static boolean mailPreferencesSet() {
        return MuConfigurations.getPreferences().isVariableSet(MuPreference.SMTP_SERVER) && MuConfigurations.getPreferences().isVariableSet(MuPreference.MAIL_SENDER_NAME) && MuConfigurations.getPreferences().isVariableSet(MuPreference.MAIL_SENDER_ADDRESS);
    }

    private void showErrorDialog(String message) {
        this.showErrorDialog(this.errorDialogTitle, message, new String[]{CLOSE_TEXT}, new int[]{11});
        this.interrupt();
    }

    private void openConnection() throws IOException {
        this.socket = new Socket(this.mailServer, MuConfigurations.getPreferences().getVariable(MuPreference.SMTP_PORT, 25));
        this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "UTF-8"));
        this.out = this.socket.getOutputStream();
        this.out64 = new Base64OutputStream(this.out, true);
        this.connectedToMailServer = true;
    }

    private void sendBody() throws IOException {
        this.readWriteLine("HELO muCommander");
        this.readWriteLine("MAIL FROM: " + this.fromAddress);
        Vector<String> recipients = new Vector<String>();
        this.recipientString = this.splitRecipientString(this.recipientString, recipients);
        int nbRecipients = recipients.size();
        for (int i = 0; i < nbRecipients; ++i) {
            this.readWriteLine("RCPT TO: <" + (String)recipients.get(i) + ">");
        }
        this.readWriteLine("DATA");
        this.writeLine("MIME-Version: 1.0");
        this.writeLine("Subject: " + this.mailSubject);
        this.writeLine("From: " + this.fromName + " <" + this.fromAddress + ">");
        this.writeLine("To: " + this.recipientString);
        this.writeLine("Content-Type: multipart/mixed; boundary=\"" + this.boundary + "\"");
        this.writeLine("\r\n--" + this.boundary);
        this.writeLine("Content-Type: text/plain; charset=\"utf-8\"\r\n");
        this.writeLine(this.mailBody + "\r\n\r\n");
        this.writeLine("\r\n--" + this.boundary);
    }

    private String splitRecipientString(String recipientsStr, List<String> recipients) {
        StringBuilder newRecipientsSb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(recipientsStr, ",;");
        while (st.hasMoreTokens()) {
            int pos2;
            String rec = st.nextToken().trim();
            int pos1 = rec.indexOf(60);
            if (pos1 != -1 && (pos2 = rec.indexOf(62, pos1 + 1)) != -1) {
                recipients.add(rec.substring(pos1 + 1, pos2));
            } else {
                recipients.add(rec);
            }
            newRecipientsSb.append(rec);
            if (!st.hasMoreTokens()) continue;
            newRecipientsSb.append(", ");
        }
        return newRecipientsSb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAttachment(AbstractFile file) throws IOException {
        InputStream fileIn = null;
        try {
            String mimeType = MimeTypes.getMimeType(file);
            if (mimeType == null) {
                mimeType = "application/octet-stream";
            }
            this.writeLine("Content-Type:" + mimeType + "; name=" + file.getName());
            this.writeLine("Content-Disposition: attachment;filename=\"" + file.getName() + "\"");
            this.writeLine("Content-transfer-encoding: base64\r\n");
            fileIn = this.setCurrentInputStream(file.getInputStream());
            StreamUtils.copyStream(fileIn, this.out64);
            this.out64.writePadding();
            this.writeLine("\r\n--" + this.boundary);
        }
        finally {
            if (fileIn != null) {
                fileIn.close();
            }
        }
    }

    private void sayGoodBye() throws IOException {
        this.writeLine("\r\n\r\n--" + this.boundary + "--\r\n");
        this.readWriteLine(".");
        this.readWriteLine("QUIT");
    }

    private void closeConnection() {
        try {
            this.socket.close();
            this.in.close();
            this.out64.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void readWriteLine(String s) throws IOException {
        this.out.write((s + "\r\n").getBytes("UTF-8"));
        this.in.readLine();
    }

    private void writeLine(String s) throws IOException {
        this.out.write((s + "\r\n").getBytes("UTF-8"));
    }

    @Override
    protected boolean processFile(AbstractFile file, Object recurseParams) {
        if (this.getState() == 3) {
            return false;
        }
        try {
            this.sendAttachment(file);
        }
        catch (IOException e) {
            this.showErrorDialog(Translator.get("email.send_file_error", file.getName()));
            return false;
        }
        if (this.getCurrentFileIndex() == this.getNbFiles() - 1) {
            try {
                this.sayGoodBye();
            }
            catch (IOException e) {
                this.showErrorDialog(Translator.get("email.goodbye_failed", new String[0]));
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean hasFolderChanged(AbstractFile folder) {
        return false;
    }

    @Override
    protected void jobStarted() {
        super.jobStarted();
        try {
            this.openConnection();
        }
        catch (IOException e) {
            this.showErrorDialog(Translator.get("email.server_unavailable", this.mailServer));
        }
        if (this.getState() == 3) {
            return;
        }
        try {
            this.sendBody();
        }
        catch (IOException e) {
            this.showErrorDialog(Translator.get("email.connection_closed", new String[0]));
        }
    }

    @Override
    protected void jobStopped() {
        super.jobStopped();
        this.closeConnection();
    }

    @Override
    public String getStatusString() {
        if (this.connectedToMailServer) {
            return Translator.get("email.sending_file", this.getCurrentFilename());
        }
        return Translator.get("email.connecting_to_server", this.mailServer);
    }
}

