/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.job;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.file.util.FileSet;
import com.mucommander.job.CopyJob;
import com.mucommander.ui.dialog.file.ProgressDialog;
import com.mucommander.ui.main.MainFrame;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempCopyJob
extends CopyJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(TempCopyJob.class);

    public TempCopyJob(ProgressDialog progressDialog, MainFrame mainFrame, AbstractFile fileToCopy) {
        super(progressDialog, mainFrame, new FileSet(fileToCopy.getParent(), fileToCopy), FileFactory.getTemporaryFolder(), TempCopyJob.getTemporaryFileName(fileToCopy), 0, 2);
    }

    public TempCopyJob(ProgressDialog progressDialog, MainFrame mainFrame, FileSet filesToCopy) {
        super(progressDialog, mainFrame, filesToCopy, TempCopyJob.getTemporaryFolder(filesToCopy), null, 0, 2);
    }

    protected static AbstractFile getTemporaryFolder(FileSet files) {
        AbstractFile tempFolder;
        try {
            tempFolder = FileFactory.getTemporaryFile(files.getBaseFolder().getName(), true);
            tempFolder.mkdir();
        }
        catch (IOException e) {
            tempFolder = FileFactory.getTemporaryFolder();
        }
        return tempFolder;
    }

    protected static String getTemporaryFileName(AbstractFile files) {
        try {
            return FileFactory.getTemporaryFile(files.getName(), true).getName();
        }
        catch (IOException e) {
            LOGGER.warn("Caught exception instanciating temporary file, this should not happen!");
            return files.getName();
        }
    }
}

