/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.job;

import com.apple.eio.FileManager;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileOperation;
import com.mucommander.commons.file.FilePermissions;
import com.mucommander.commons.file.impl.local.LocalFile;
import com.mucommander.commons.file.util.FileSet;
import com.mucommander.commons.io.ByteCounter;
import com.mucommander.commons.io.ChecksumInputStream;
import com.mucommander.commons.io.CounterInputStream;
import com.mucommander.commons.io.FileTransferException;
import com.mucommander.commons.io.ThroughputLimitInputStream;
import com.mucommander.commons.io.security.MuProvider;
import com.mucommander.commons.runtime.OsFamilies;
import com.mucommander.job.FileJob;
import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.file.ProgressDialog;
import com.mucommander.ui.main.MainFrame;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TransferFileJob
extends FileJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransferFileJob.class);
    private ByteCounter currentFileByteCounter = new ByteCounter();
    private ByteCounter currentFileSkippedByteCounter = new ByteCounter();
    private ByteCounter totalByteCounter = new ByteCounter(this.currentFileByteCounter);
    private ByteCounter totalSkippedByteCounter = new ByteCounter(this.currentFileSkippedByteCounter);
    private ThroughputLimitInputStream tlin;
    private long throughputLimit = -1L;
    private boolean currentFileSkipped;
    private boolean integrityCheckEnabled;
    private boolean isCheckingIntegrity;

    public TransferFileJob(ProgressDialog progressDialog, MainFrame mainFrame, FileSet files) {
        super(progressDialog, mainFrame, files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyFile(AbstractFile abstractFile, AbstractFile abstractFile2, boolean bl) throws FileTransferException {
        this.isCheckingIntegrity = false;
        if (abstractFile.equalsCanonical(abstractFile2)) {
            throw new FileTransferException(1);
        }
        boolean bl2 = false;
        if (abstractFile.isFileOperationSupported(FileOperation.COPY_REMOTELY)) {
            try {
                abstractFile.copyRemotelyTo(abstractFile2);
                bl2 = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        InputStream inputStream = null;
        if (!bl2) {
            try {
                long l = abstractFile.getSize();
                try {
                    long l2 = abstractFile2.getSize();
                    if (bl && l2 != -1L) {
                        inputStream = abstractFile.getInputStream(l2);
                        l -= l2;
                        this.currentFileByteCounter.add(l2);
                        this.currentFileSkippedByteCounter.add(l2);
                    } else {
                        inputStream = abstractFile.getInputStream();
                        if (this.integrityCheckEnabled) {
                            inputStream = new ChecksumInputStream(inputStream, MessageDigest.getInstance("Adler32"));
                        }
                    }
                    this.setCurrentInputStream(inputStream);
                }
                catch (Exception exception) {
                    LOGGER.debug("IOException caught, throwing FileTransferException", exception);
                    throw new FileTransferException(2);
                }
                abstractFile2.copyStream(this.tlin, bl, l);
            }
            finally {
                this.closeCurrentInputStream();
            }
        }
        if (abstractFile2.isFileOperationSupported(FileOperation.CHANGE_DATE)) {
            try {
                abstractFile2.changeDate(abstractFile.getDate());
            }
            catch (IOException iOException) {
                LOGGER.debug("failed to change the date of " + abstractFile2, iOException);
            }
        }
        if (abstractFile2.isFileOperationSupported(FileOperation.CHANGE_PERMISSION)) {
            try {
                abstractFile2.importPermissions(abstractFile, FilePermissions.DEFAULT_FILE_PERMISSIONS);
            }
            catch (IOException iOException) {
                LOGGER.debug("failed to import " + abstractFile + " permissions into " + abstractFile2, iOException);
            }
        }
        if (OsFamilies.MAC_OS_X.isCurrent() && abstractFile.hasAncestor(LocalFile.class) && abstractFile2.hasAncestor(LocalFile.class)) {
            String string = abstractFile.getAbsolutePath();
            try {
                FileManager.setFileTypeAndCreator((String)abstractFile2.getAbsolutePath(), (int)FileManager.getFileType((String)string), (int)FileManager.getFileCreator((String)string));
            }
            catch (IOException iOException) {
                LOGGER.debug("Error while setting Mac OS X file type and creator on destination", iOException);
            }
        }
        if (this.integrityCheckEnabled) {
            String string;
            String string2;
            this.isCheckingIntegrity = true;
            if (inputStream != null && inputStream instanceof ChecksumInputStream) {
                string2 = ((ChecksumInputStream)inputStream).getChecksumString();
            } else {
                try {
                    string2 = this.calculateChecksum(abstractFile);
                }
                catch (Exception exception) {
                    throw new FileTransferException(4);
                }
            }
            LOGGER.debug("Source checksum= " + string2);
            try {
                string = this.calculateChecksum(abstractFile2);
            }
            catch (Exception exception) {
                throw new FileTransferException(12);
            }
            LOGGER.debug("Destination checksum= " + string);
            if (!string2.equals(string)) {
                throw new FileTransferException(13);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String calculateChecksum(AbstractFile file) throws IOException, NoSuchAlgorithmException {
        this.currentFileByteCounter.reset();
        InputStream in = this.setCurrentInputStream(file.getInputStream());
        try {
            String string = AbstractFile.calculateChecksum(in, MessageDigest.getInstance("Adler32"));
            return string;
        }
        finally {
            this.closeCurrentInputStream();
        }
    }

    protected boolean tryCopyFile(AbstractFile sourceFile, AbstractFile destFile, boolean append, String errorDialogTitle) {
        while (true) {
            try {
                this.copyFile(sourceFile, destFile, append);
                return true;
            }
            catch (FileTransferException e) {
                int choice;
                if (this.getState() == 3 || this.wasCurrentFileSkipped()) {
                    return false;
                }
                LOGGER.debug("Copy failed", e);
                int reason = e.getReason();
                switch (reason) {
                    case 2: {
                        choice = this.showErrorDialog(errorDialogTitle, Translator.get("cannot_read_file", sourceFile.getName()));
                        break;
                    }
                    case 3: {
                        choice = this.showErrorDialog(errorDialogTitle, Translator.get("cannot_write_file", destFile.getName()));
                        break;
                    }
                    case 1: {
                        choice = this.showErrorDialog(errorDialogTitle, Translator.get("same_source_destination", new String[0]));
                        break;
                    }
                    case 13: {
                        choice = this.showErrorDialog(errorDialogTitle, Translator.get("integrity_check_error", new String[0]));
                        break;
                    }
                    default: {
                        choice = this.showErrorDialog(errorDialogTitle, Translator.get("error_while_transferring", sourceFile.getName()), new String[]{SKIP_TEXT, SKIP_ALL_TEXT, APPEND_TEXT, RETRY_TEXT, CANCEL_TEXT}, new int[]{0, 1, 4, 2, 3});
                    }
                }
                if (choice == 2 || choice == 4) {
                    this.currentFileByteCounter.reset();
                    this.currentFileSkippedByteCounter.reset();
                    append = choice == 4;
                    continue;
                }
                return false;
            }
            break;
        }
    }

    protected synchronized InputStream setCurrentInputStream(InputStream in) {
        if (this.tlin == null) {
            this.tlin = new ThroughputLimitInputStream(new CounterInputStream(in, this.currentFileByteCounter), this.throughputLimit);
        } else {
            this.tlin.setUnderlyingInputStream(new CounterInputStream(in, this.currentFileByteCounter));
        }
        return this.tlin;
    }

    protected synchronized void closeCurrentInputStream() {
        if (this.tlin != null) {
            try {
                this.tlin.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean isIntegrityCheckEnabled() {
        return this.integrityCheckEnabled;
    }

    public void setIntegrityCheckEnabled(boolean integrityCheckEnabled) {
        this.integrityCheckEnabled = integrityCheckEnabled;
    }

    protected boolean isCheckingIntegrity() {
        return this.isCheckingIntegrity;
    }

    public synchronized void skipCurrentFile() {
        if (this.tlin != null) {
            LOGGER.debug("skipping current file, closing " + this.tlin);
            this.currentFileSkipped = true;
            this.closeCurrentInputStream();
        }
        if (this.getState() == 2) {
            this.setPaused(false);
        }
    }

    public synchronized boolean wasCurrentFileSkipped() {
        return this.currentFileSkipped;
    }

    public float getFilePercentDone() {
        long currentFileSize = this.getCurrentFileSize();
        if (currentFileSize <= 0L) {
            return 0.0f;
        }
        return (float)this.getCurrentFileByteCounter().getByteCount() / (float)currentFileSize;
    }

    public ByteCounter getCurrentFileByteCounter() {
        return this.currentFileByteCounter;
    }

    public long getCurrentFileSize() {
        return this.getCurrentFile() == null ? -1L : this.getCurrentFile().getSize();
    }

    public ByteCounter getTotalByteCounter() {
        return this.totalByteCounter;
    }

    public ByteCounter getTotalSkippedByteCounter() {
        return this.totalSkippedByteCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThroughputLimit(long bytesPerSecond) {
        this.throughputLimit = bytesPerSecond <= 0L ? -1L : bytesPerSecond;
        TransferFileJob transferFileJob = this;
        synchronized (transferFileJob) {
            if (this.getState() != 2 && this.tlin != null) {
                this.tlin.setThroughputLimit(this.throughputLimit);
            }
        }
    }

    public long getThroughputLimit() {
        return this.throughputLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void jobStopped() {
        super.jobStopped();
        TransferFileJob transferFileJob = this;
        synchronized (transferFileJob) {
            if (this.tlin != null) {
                LOGGER.debug("closing current InputStream " + this.tlin);
                this.closeCurrentInputStream();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void jobPaused() {
        super.jobPaused();
        TransferFileJob transferFileJob = this;
        synchronized (transferFileJob) {
            if (this.tlin != null) {
                this.tlin.setThroughputLimit(0L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void jobResumed() {
        super.jobResumed();
        TransferFileJob transferFileJob = this;
        synchronized (transferFileJob) {
            if (this.tlin != null) {
                this.tlin.setThroughputLimit(this.throughputLimit);
            }
        }
    }

    protected void nextFile(AbstractFile file) {
        this.totalByteCounter.add(this.currentFileByteCounter, true);
        this.totalSkippedByteCounter.add(this.currentFileSkippedByteCounter, true);
        this.currentFileSkipped = false;
        super.nextFile(file);
    }

    public float getTotalPercentDone() {
        long currentFileSize;
        float nbFilesProcessed = this.getCurrentFileIndex();
        int nbFiles = this.getNbFiles();
        if (this.getCurrentFile() != null && nbFilesProcessed != (float)nbFiles && this.files.indexOf(this.getCurrentFile()) != -1 && !this.getCurrentFile().isDirectory() && (currentFileSize = this.getCurrentFile().getSize()) > 0L) {
            nbFilesProcessed += (float)this.getCurrentFileByteCounter().getByteCount() / (float)currentFileSize;
        }
        return nbFilesProcessed / (float)nbFiles;
    }

    public String getStatusString() {
        if (this.isCheckingIntegrity()) {
            return Translator.get("progress_dialog.verifying_file", this.getCurrentFilename());
        }
        return super.getStatusString();
    }

    static {
        MuProvider.registerProvider();
    }
}

