/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.job;

import com.mucommander.commons.file.AbstractArchiveFile;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.AbstractRWArchiveFile;
import com.mucommander.commons.file.ArchiveEntry;
import com.mucommander.commons.file.ArchiveEntryIterator;
import com.mucommander.commons.file.impl.ProxyFile;
import com.mucommander.commons.file.util.FileSet;
import com.mucommander.job.AbstractCopyJob;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.ActionManager;
import com.mucommander.ui.dialog.file.ProgressDialog;
import com.mucommander.ui.main.MainFrame;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnpackJob
extends AbstractCopyJob {
    protected List<ArchiveEntry> selectedEntries;
    protected int baseArchiveDepth;

    public UnpackJob(ProgressDialog progressDialog, MainFrame mainFrame, FileSet files, AbstractFile destFolder, int fileExistsAction) {
        super(progressDialog, mainFrame, files, destFolder, null, fileExistsAction);
        this.errorDialogTitle = Translator.get("unpack_dialog.error_title", new String[0]);
        this.baseArchiveDepth = 0;
    }

    public UnpackJob(ProgressDialog progressDialog, MainFrame mainFrame, AbstractArchiveFile archiveFile, int baseArchiveDepth, AbstractFile destFolder, String newName, int fileExistsAction, List<ArchiveEntry> selectedEntries) {
        super(progressDialog, mainFrame, new FileSet(archiveFile.getParent(), archiveFile), destFolder, newName, fileExistsAction);
        this.errorDialogTitle = Translator.get("unpack_dialog.error_title", new String[0]);
        this.baseArchiveDepth = baseArchiveDepth;
        this.selectedEntries = selectedEntries;
    }

    @Override
    protected void jobStarted() {
        super.jobStarted();
        if (!this.baseDestFolder.exists()) {
            while (true) {
                try {
                    this.baseDestFolder.mkdir();
                }
                catch (IOException e) {
                    int ret = this.showErrorDialog(this.errorDialogTitle, Translator.get("cannot_create_folder", this.baseDestFolder.getName()));
                    if (ret == 2) continue;
                    this.interrupt();
                }
                break;
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    protected boolean processFile(AbstractFile var1_1, Object var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 26[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected boolean hasFolderChanged(AbstractFile folder) {
        return this.baseDestFolder.isParentOf(folder);
    }

    @Override
    protected void jobCompleted() {
        super.jobCompleted();
        AbstractArchiveFile archiveFile = this.baseDestFolder.getParentArchive();
        if (archiveFile != null && archiveFile.isArchive() && archiveFile.isWritable()) {
            this.optimizeArchive((AbstractRWArchiveFile)archiveFile);
        }
        if (this.selectedEntries != null) {
            ActionManager.performAction("UnmarkAll", this.getMainFrame());
        }
    }

    @Override
    public String getStatusString() {
        if (this.isCheckingIntegrity()) {
            return super.getStatusString();
        }
        if (this.isOptimizingArchive) {
            return Translator.get("optimizing_archive", this.archiveToOptimize.getName());
        }
        return Translator.get("unpack_dialog.unpacking_file", this.getCurrentFilename());
    }

    private static class ProxiedEntryFile
    extends ProxyFile {
        private ArchiveEntry entry;
        private AbstractArchiveFile archiveFile;
        private ArchiveEntryIterator iterator;

        public ProxiedEntryFile(AbstractFile entryFile, ArchiveEntry entry, AbstractArchiveFile archiveFile, ArchiveEntryIterator iterator) {
            super(entryFile);
            this.entry = entry;
            this.archiveFile = archiveFile;
            this.iterator = iterator;
        }

        public InputStream getInputStream() throws IOException {
            return this.archiveFile.getEntryInputStream(this.entry, this.iterator);
        }
    }
}

