/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.job.progress;

import com.mucommander.job.FileJob;
import com.mucommander.job.TransferFileJob;
import com.mucommander.text.DurationFormat;
import com.mucommander.text.Translator;

public class JobProgress {
    private FileJob job;
    private TransferFileJob transferFileJob;
    private long effectiveJobTime;
    private long lastTime;
    private int totalPercentInt;
    private String totalProgressText;
    private int filePercentInt;
    private String fileProgressText;
    private long currentBps;
    private long bytesTotal;
    private long totalBps;
    private long lastBytesTotal;
    private String jobStatusString;
    private long jobPauseStartDate;

    public JobProgress(FileJob job) {
        this.job = job;
        if (job instanceof TransferFileJob) {
            this.transferFileJob = (TransferFileJob)job;
        }
        this.lastBytesTotal = 0L;
        this.lastTime = System.currentTimeMillis();
    }

    public boolean calcJobProgress(boolean fullUpdate) {
        int jobState = this.job.getState();
        this.jobPauseStartDate = this.job.getPauseStartDate();
        if (jobState == 4 || jobState == 3) {
            this.jobStatusString = Translator.get("progress_dialog.job_finished", new String[0]);
            fullUpdate = true;
        } else {
            this.jobStatusString = this.job.getStatusString();
        }
        if (!fullUpdate) {
            return false;
        }
        if (jobState == 2) {
            return false;
        }
        long now = this.job.getEndDate();
        if (now == 0L) {
            now = System.currentTimeMillis();
        }
        long currentFileRemainingTime = 0L;
        this.effectiveJobTime = this.job.getEffectiveJobTime();
        if (this.effectiveJobTime == 0L) {
            this.effectiveJobTime = 1L;
        }
        if (this.transferFileJob != null) {
            this.bytesTotal = this.transferFileJob.getTotalByteCounter().getByteCount() - this.transferFileJob.getTotalSkippedByteCounter().getByteCount();
            this.totalBps = (long)((double)this.bytesTotal * 1000.0 / (double)this.effectiveJobTime);
            this.currentBps = now - this.lastTime > 0L ? (long)((double)(this.bytesTotal - this.lastBytesTotal) * 1000.0 / (double)(now - this.lastTime)) : 0L;
            float filePercentFloat = this.transferFileJob.getFilePercentDone();
            this.filePercentInt = (int)(100.0f * filePercentFloat);
            this.fileProgressText = this.filePercentInt + "%";
            if (filePercentFloat < 1.0f) {
                this.fileProgressText = this.fileProgressText + " - ";
                long currentFileSize = this.transferFileJob.getCurrentFileSize();
                if (currentFileSize == -1L) {
                    this.fileProgressText = this.fileProgressText + "?";
                } else if (this.totalBps == 0L) {
                    currentFileRemainingTime = -1L;
                    this.fileProgressText = this.fileProgressText + DurationFormat.getInfiniteSymbol();
                } else {
                    currentFileRemainingTime = (long)((float)(1000L * (currentFileSize - this.transferFileJob.getCurrentFileByteCounter().getByteCount())) / (float)this.totalBps);
                    this.fileProgressText = this.fileProgressText + DurationFormat.format(currentFileRemainingTime);
                }
            }
            this.lastBytesTotal = this.bytesTotal;
            this.lastTime = now;
        }
        float totalPercentFloat = this.job.getTotalPercentDone();
        this.totalPercentInt = (int)(100.0f * totalPercentFloat);
        this.totalProgressText = this.totalPercentInt + "%";
        if (totalPercentFloat < 1.0f) {
            this.totalProgressText = this.totalProgressText + " - ";
            if (totalPercentFloat == 0.0f) {
                this.totalProgressText = this.totalProgressText + "?";
            } else {
                long totalRemainingTime = (long)((1.0f - totalPercentFloat) * ((float)this.effectiveJobTime / totalPercentFloat));
                totalRemainingTime = Math.max(totalRemainingTime, currentFileRemainingTime);
                this.totalProgressText = this.totalProgressText + DurationFormat.format(totalRemainingTime);
            }
        }
        return true;
    }

    public String getJobStatusString() {
        return this.jobStatusString;
    }

    public boolean isTransferFileJob() {
        return this.transferFileJob != null;
    }

    public int getFilePercentInt() {
        return this.filePercentInt;
    }

    public String getFileProgressText() {
        return this.fileProgressText;
    }

    public long getBytesTotal() {
        return this.bytesTotal;
    }

    public long getTotalBps() {
        return this.totalBps;
    }

    public long getLastTime() {
        return this.lastTime;
    }

    public long getCurrentBps() {
        return this.currentBps;
    }

    public int getTotalPercentInt() {
        return this.totalPercentInt;
    }

    public String getTotalProgressText() {
        return this.totalProgressText;
    }

    public long getEffectiveJobTime() {
        return this.effectiveJobTime;
    }

    public long getJobPauseStartDate() {
        return this.jobPauseStartDate;
    }
}

