/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.job.progress;

import com.mucommander.job.FileJob;
import com.mucommander.job.FileJobListener;
import com.mucommander.job.progress.JobProgress;
import com.mucommander.job.progress.JobProgressListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.EventListenerList;

public class JobProgressMonitor
implements FileJobListener {
    private Timer progressTimer;
    private EventListenerList listenerList = new EventListenerList();
    private List<FileJob> jobs = new ArrayList<FileJob>();
    private static final JobProgressMonitor instance = new JobProgressMonitor();

    private JobProgressMonitor() {
        JobProgressTimer timerListener = new JobProgressTimer();
        this.progressTimer = new Timer(100, timerListener);
    }

    public static JobProgressMonitor getInstance() {
        return instance;
    }

    public void addJobProgressListener(JobProgressListener jobProgressListener) {
        this.listenerList.add(JobProgressListener.class, jobProgressListener);
    }

    public void removeJobProgressListener(JobProgressListener jobProgressListener) {
        this.listenerList.remove(JobProgressListener.class, jobProgressListener);
    }

    private void fireJobProgress(FileJob source, boolean fullUpdate) {
        int idx = this.jobs.indexOf(source);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            ((JobProgressListener)listeners[i + 1]).jobProgress(source, idx, fullUpdate);
        }
    }

    private void fireJobAdded(FileJob source, int idx) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            ((JobProgressListener)listeners[i + 1]).jobAdded(source, idx);
        }
    }

    private void fireJobRemoved(FileJob source, int idx) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            ((JobProgressListener)listeners[i + 1]).jobRemoved(source, idx);
        }
    }

    public void addJob(final FileJob job) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JobProgressMonitor.this.addJob(job);
                }
            });
        }
        this.jobs.add(job);
        int idx = this.jobs.size() - 1;
        this.fireJobAdded(job, idx);
        if (!this.progressTimer.isRunning()) {
            this.progressTimer.start();
        }
        job.addFileJobListener(this);
    }

    public void removeJob(final FileJob job) {
        int idx;
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JobProgressMonitor.this.removeJob(job);
                }
            });
        }
        if ((idx = this.jobs.indexOf(job)) != -1) {
            this.jobs.remove(idx);
        }
        if (this.jobs.isEmpty()) {
            this.progressTimer.stop();
        }
        this.fireJobRemoved(job, idx);
        job.removeFileJobListener(this);
    }

    public void jobStateChanged(final FileJob source, int oldState, int newState) {
        if (newState == 4 || newState == 3) {
            ActionListener jobToRemove = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JobProgressMonitor.this.removeJob(source);
                }
            };
            Timer timer = new Timer(1500, jobToRemove);
            timer.setRepeats(false);
            timer.start();
        }
    }

    private class JobProgressTimer
    implements ActionListener {
        private int loopCount = 0;

        private JobProgressTimer() {
        }

        public void actionPerformed(ActionEvent e) {
            boolean fullUpdate;
            ++this.loopCount;
            if (this.loopCount >= 10) {
                fullUpdate = true;
                this.loopCount = 0;
            } else {
                fullUpdate = false;
            }
            for (FileJob job : JobProgressMonitor.this.jobs) {
                JobProgress jobProgress = job.getJobProgress();
                boolean updateFullUI = jobProgress.calcJobProgress(fullUpdate);
                JobProgressMonitor.this.fireJobProgress(job, updateFullUI);
            }
        }
    }
}

