/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.process;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.file.impl.local.LocalFile;
import com.mucommander.process.AbstractProcess;
import com.mucommander.process.LocalProcess;
import com.mucommander.process.ProcessListener;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;

public class ProcessRunner {
    private ProcessRunner() {
    }

    public static AbstractProcess execute(String[] tokens, AbstractFile currentDirectory, ProcessListener listener, String encoding) throws IOException {
        if (currentDirectory == null) {
            currentDirectory = FileFactory.getFile(System.getProperty("user.dir"), true);
        } else if (!currentDirectory.hasAncestor(LocalFile.class)) {
            currentDirectory = FileFactory.getFile(System.getProperty("user.home"), true);
        } else {
            while (currentDirectory != null && !currentDirectory.isDirectory()) {
                currentDirectory = currentDirectory.getParent();
            }
            if (currentDirectory == null) {
                currentDirectory = FileFactory.getFile(System.getProperty("user.dir"), true);
            }
        }
        LocalProcess process = new LocalProcess(tokens, (File)currentDirectory.getUnderlyingFileObject());
        process.startMonitoring(listener, encoding);
        return process;
    }

    public static AbstractProcess execute(String command) throws IOException {
        return ProcessRunner.execute(command, null, null, null);
    }

    public static AbstractProcess execute(String command, AbstractFile currentDirectory, ProcessListener listener, String encoding) throws IOException {
        StringTokenizer parser = new StringTokenizer(command);
        String[] tokens = new String[parser.countTokens()];
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = parser.nextToken();
        }
        return ProcessRunner.execute(tokens, currentDirectory, listener, encoding);
    }

    public static AbstractProcess execute(String[] tokens, AbstractFile currentDirectory, ProcessListener listener) throws IOException {
        return ProcessRunner.execute(tokens, currentDirectory, listener, null);
    }

    public static AbstractProcess execute(String[] tokens) throws IOException {
        return ProcessRunner.execute(tokens, null, null, null);
    }

    public static AbstractProcess execute(String[] tokens, ProcessListener listener) throws IOException {
        return ProcessRunner.execute(tokens, null, listener, null);
    }

    public static AbstractProcess execute(String[] tokens, AbstractFile currentDirectory) throws IOException {
        return ProcessRunner.execute(tokens, currentDirectory, null, null);
    }
}

