/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.shell;

import com.mucommander.command.Command;
import com.mucommander.commons.conf.ConfigurationEvent;
import com.mucommander.commons.conf.ConfigurationListener;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.impl.local.LocalFile;
import com.mucommander.conf.MuConfigurations;
import com.mucommander.conf.MuPreference;
import com.mucommander.desktop.DesktopManager;
import com.mucommander.process.AbstractProcess;
import com.mucommander.process.ProcessListener;
import com.mucommander.process.ProcessListenerList;
import com.mucommander.process.ProcessRunner;
import com.mucommander.shell.ShellEncodingListener;
import com.mucommander.shell.ShellHistoryManager;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Shell
implements ConfigurationListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(Shell.class);
    private static String encoding;
    private static boolean autoDetectEncoding;
    private static String[] tokens;
    private static String[] remoteTokens;
    private static Shell confListener;

    private Shell() {
    }

    public static synchronized AbstractProcess execute(String string, AbstractFile abstractFile, ProcessListener processListener) throws IOException {
        String[] stringArray;
        LOGGER.debug("Executing " + string);
        ShellHistoryManager.add(string);
        if (abstractFile.hasAncestor(LocalFile.class)) {
            Shell.tokens[Shell.tokens.length - 1] = string;
            stringArray = tokens;
        } else {
            Shell.remoteTokens[0] = string;
            stringArray = remoteTokens;
        }
        if (autoDetectEncoding) {
            if (processListener == null) {
                processListener = new ShellEncodingListener();
            } else {
                ProcessListenerList processListenerList = new ProcessListenerList();
                processListenerList.add(processListener);
                processListenerList.add(new ShellEncodingListener());
                processListener = processListenerList;
            }
        }
        return encoding == null ? ProcessRunner.execute(stringArray, abstractFile, processListener) : ProcessRunner.execute(stringArray, abstractFile, processListener, encoding);
    }

    private static synchronized void setShellCommand() {
        String shellCommand = MuConfigurations.getPreferences().getVariable(MuPreference.USE_CUSTOM_SHELL, false) ? MuConfigurations.getPreferences().getVariable(MuPreference.CUSTOM_SHELL, DesktopManager.getDefaultShell()) : DesktopManager.getDefaultShell();
        String[] buffer = Command.getTokens(shellCommand);
        tokens = new String[buffer.length + 1];
        System.arraycopy(buffer, 0, tokens, 0, buffer.length);
        encoding = MuConfigurations.getPreferences().getVariable(MuPreference.SHELL_ENCODING);
        autoDetectEncoding = MuConfigurations.getPreferences().getVariable(MuPreference.AUTODETECT_SHELL_ENCODING, true);
    }

    public void configurationChanged(ConfigurationEvent event) {
        if (event.getVariable().startsWith("shell")) {
            Shell.setShellCommand();
        }
    }

    static {
        confListener = new Shell();
        MuConfigurations.addPreferencesListener(confListener);
        Shell.setShellCommand();
        remoteTokens = new String[1];
    }
}

