/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.shell;

import com.mucommander.shell.ShellHistoryManager;
import java.io.InputStream;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ShellHistoryReader
extends DefaultHandler {
    private int status = 0;
    private StringBuilder command = new StringBuilder();
    private String version;

    private ShellHistoryReader() {
    }

    public static void read(InputStream in) throws Exception {
        SAXParserFactory.newInstance().newSAXParser().parse(in, (DefaultHandler)new ShellHistoryReader());
    }

    public void characters(char[] ch, int start, int length) {
        if (this.status == 2) {
            this.command.append(ch, start, length);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("history") && this.status == 0) {
            this.status = 1;
            this.version = attributes.getValue("version");
        } else if (qName.equals("command") && this.status == 1) {
            this.status = 2;
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("history") && this.status == 1) {
            this.status = 0;
        } else if (qName.equals("command") && this.status == 2) {
            this.status = 1;
            ShellHistoryManager.add(this.command.toString().trim());
            this.command.setLength(0);
        }
    }
}

