/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.shell;

import com.mucommander.RuntimeConstants;
import com.mucommander.shell.ShellHistoryManager;
import com.mucommander.xml.XmlAttributes;
import com.mucommander.xml.XmlWriter;
import java.io.OutputStream;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ShellHistoryWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShellHistoryWriter.class);

    ShellHistoryWriter() {
    }

    public static void write(OutputStream stream) {
        Iterator<String> history = ShellHistoryManager.getHistoryIterator();
        try {
            XmlWriter out = new XmlWriter(stream);
            XmlAttributes attributes = new XmlAttributes();
            attributes.add("version", RuntimeConstants.VERSION);
            out.startElement("history", attributes);
            out.println();
            while (history.hasNext()) {
                out.startElement("command");
                out.writeCData(history.next());
                out.endElement("command");
            }
            out.endElement("history");
        }
        catch (Exception e) {
            LOGGER.debug("Failed to write shell history", e);
        }
    }
}

