/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.text;

import com.mucommander.text.Translator;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class SizeFormat {
    private static final DecimalFormat DECIMAL_FORMAT = (DecimalFormat)NumberFormat.getInstance();
    private static final String DECIMAL_SEPARATOR = "" + DECIMAL_FORMAT.getDecimalFormatSymbols().getDecimalSeparator();
    private static final String BYTE = Translator.get("unit.byte", new String[0]);
    private static final String BYTES = Translator.get("unit.bytes", new String[0]);
    private static final String B = Translator.get("unit.bytes_short", new String[0]);
    private static final String KB = Translator.get("unit.kb", new String[0]);
    private static final String MB = Translator.get("unit.mb", new String[0]);
    private static final String GB = Translator.get("unit.gb", new String[0]);
    private static final String TB = Translator.get("unit.tb", new String[0]);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String format(long size, int format) {
        String unitString;
        String digitsString;
        boolean roundToKb;
        if (size < 0L) {
            return "?";
        }
        boolean unitLong = (format & 0x10) != 0;
        boolean unitShort = (format & 8) != 0;
        boolean noUnit = !unitLong && !unitShort;
        boolean digitsShort = (format & 1) != 0;
        boolean bl = roundToKb = (format & 0x80) != 0;
        if (size < 1024L) {
            if (roundToKb) {
                digitsString = size == 0L ? "0" : "1";
                unitString = noUnit ? "" : KB;
            } else {
                digitsString = "" + size;
                unitString = unitLong ? (size <= 1L ? BYTE : BYTES) : (unitShort ? B : "");
            }
        } else if ((format & 4) != 0) {
            DecimalFormat decimalFormat = DECIMAL_FORMAT;
            synchronized (decimalFormat) {
                digitsString = DECIMAL_FORMAT.format(size);
            }
            unitString = unitLong ? BYTES : (unitShort ? B : "");
        } else if (size < 10240L && !digitsShort) {
            int nKB = (int)size / 1024;
            digitsString = nKB + DECIMAL_SEPARATOR + (int)((float)(size - (long)(nKB * 1024)) / 1024.0f * 10.0f);
            unitString = noUnit ? "" : KB;
        } else if (size < 0x100000L) {
            digitsString = "" + size / 1024L;
            unitString = noUnit ? "" : KB;
        } else if (size < 0xA00000L && !digitsShort) {
            int nMB = (int)size / 0x100000;
            digitsString = nMB + DECIMAL_SEPARATOR + (int)((float)(size - (long)(nMB * 0x100000)) / 1048576.0f * 10.0f);
            unitString = noUnit ? "" : MB;
        } else if (size < 0x40000000L) {
            digitsString = "" + size / 0x100000L;
            unitString = noUnit ? "" : MB;
        } else if (size < 0x280000000L && !digitsShort) {
            long nGB = size / 0x40000000L;
            digitsString = nGB + DECIMAL_SEPARATOR + (int)((double)(size - nGB * 0x40000000L) / 1.073741824E9 * 10.0);
            unitString = noUnit ? "" : GB;
        } else if (size < 0x10000000000L) {
            digitsString = "" + size / 0x40000000L;
            unitString = noUnit ? "" : GB;
        } else if (size < 0xA0000000000L && !digitsShort) {
            long nTB = size / 0x10000000000L;
            digitsString = nTB + DECIMAL_SEPARATOR + (int)((double)(size - nTB * 0x10000000000L) / 1.099511627776E12 * 10.0);
            unitString = noUnit ? "" : TB;
        } else {
            digitsString = "" + size / 0x10000000000L;
            String string = unitString = noUnit ? "" : TB;
        }
        if ((format & 0x20) != 0) {
            unitString = Translator.get("unit.speed", unitString);
        }
        return digitsString + ((format & 0x40) != 0 ? " " : "") + unitString;
    }

    public static String getUnitString(int unit, boolean speedUnit) {
        String unitString;
        switch (unit) {
            case 0: {
                unitString = B;
                break;
            }
            case 1: {
                unitString = KB;
                break;
            }
            case 2: {
                unitString = MB;
                break;
            }
            case 3: {
                unitString = GB;
                break;
            }
            case 4: {
                unitString = TB;
                break;
            }
            default: {
                return "";
            }
        }
        return speedUnit ? Translator.get("unit.speed", unitString) : unitString;
    }

    public static long getUnitBytes(int unit) {
        long bytes;
        switch (unit) {
            case 0: {
                bytes = 1L;
                break;
            }
            case 1: {
                bytes = 1024L;
                break;
            }
            case 2: {
                bytes = 0x100000L;
                break;
            }
            case 3: {
                bytes = 0x40000000L;
                break;
            }
            case 4: {
                bytes = 0x10000000000L;
                break;
            }
            default: {
                return 0L;
            }
        }
        return bytes;
    }
}

