/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.action;

import com.mucommander.text.Translator;
import com.mucommander.ui.action.ActionProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionCategory
implements Comparable<ActionCategory> {
    private String descriptionKey;

    protected ActionCategory(String descriptionKey) {
        this.descriptionKey = descriptionKey;
    }

    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    public String getDescription() {
        return Translator.get(this.descriptionKey, new String[0]);
    }

    public boolean contains(String actionId) {
        ActionCategory actionCategory = ActionProperties.getActionCategory(actionId);
        if (actionCategory != null) {
            return this.descriptionKey.equals(actionCategory.getDescriptionKey());
        }
        return false;
    }

    public String toString() {
        String description = this.getDescription();
        if (description != null) {
            return description;
        }
        return this.getDescriptionKey();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ActionCategory) {
            return this.descriptionKey.equals(((ActionCategory)obj).descriptionKey);
        }
        return false;
    }

    @Override
    public int compareTo(ActionCategory actionCategory) {
        return this.getDescription().compareTo(actionCategory.getDescription());
    }
}

