/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.action;

import com.mucommander.ui.action.AcceleratorMap;
import com.mucommander.ui.action.ActionDescriptor;
import com.mucommander.ui.action.ActionManager;
import com.mucommander.ui.action.ActionProperties;
import com.mucommander.ui.action.MuAction;
import com.mucommander.ui.main.MainFrame;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionKeymap {
    private static HashMap<String, KeyStroke> customPrimaryActionKeymap = new HashMap();
    private static HashMap<String, KeyStroke> customAlternateActionKeymap = new HashMap();
    private static AcceleratorMap acceleratorMap = new AcceleratorMap();

    public static void registerActions(MainFrame mainFrame) {
        Iterator<String> actionIds = ActionManager.getActionIds();
        while (actionIds.hasNext()) {
            String actionId = actionIds.next();
            ActionDescriptor actionDescriptor = ActionProperties.getActionDescriptor(actionId);
            if (actionDescriptor.isParameterized()) continue;
            ActionKeymap.registerAction(mainFrame, ActionManager.getActionInstance(actionId, mainFrame));
        }
    }

    public static void registerActionAccelerators(MuAction action, JComponent comp, int condition) {
        ActionKeymap.registerActionAccelerator(action, action.getAccelerator(), comp, condition);
        ActionKeymap.registerActionAccelerator(action, action.getAlternateAccelerator(), comp, condition);
    }

    public static void changeActionAccelerators(String actionId, KeyStroke accelerator, KeyStroke alternateAccelerator) {
        String previousActionForAlternativeAccelerator;
        if (ActionKeymap.equals(accelerator, ActionKeymap.getAccelerator(actionId)) && ActionKeymap.equals(alternateAccelerator, ActionKeymap.getAlternateAccelerator(actionId))) {
            return;
        }
        String previousActionForAccelerator = ActionKeymap.getRegisteredActionIdForKeystroke(accelerator);
        if (previousActionForAccelerator != null && !previousActionForAccelerator.equals(actionId)) {
            ActionKeymap.unregisterAcceleratorFromAction(previousActionForAccelerator, accelerator);
        }
        if ((previousActionForAlternativeAccelerator = ActionKeymap.getRegisteredActionIdForKeystroke(alternateAccelerator)) != null && !previousActionForAlternativeAccelerator.equals(actionId)) {
            ActionKeymap.unregisterAcceleratorFromAction(previousActionForAlternativeAccelerator, alternateAccelerator);
        }
        acceleratorMap.remove(customPrimaryActionKeymap.remove(actionId));
        acceleratorMap.remove(customAlternateActionKeymap.remove(actionId));
        ActionKeymap.registerActionAccelerators(actionId, accelerator, alternateAccelerator);
    }

    private static void unregisterAcceleratorFromAction(String actionId, KeyStroke accelerator) {
        switch (ActionKeymap.getAcceleratorType(accelerator)) {
            case 1: {
                ActionKeymap.registerActionAccelerators(actionId, null, ActionKeymap.getAlternateAccelerator(actionId));
                break;
            }
            case 2: {
                ActionKeymap.registerActionAccelerators(actionId, ActionKeymap.getAccelerator(actionId), null);
            }
        }
    }

    public static void registerActions(HashMap<String, KeyStroke> primary, HashMap<String, KeyStroke> alternate) {
        for (String actionId : primary.keySet()) {
            ActionKeymap.registerActionAccelerators(actionId, primary.get(actionId), alternate.get(actionId));
        }
    }

    public static boolean isKeyStrokeRegistered(KeyStroke ks) {
        return ActionKeymap.getRegisteredActionIdForKeystroke(ks) != null;
    }

    public static boolean doesActionHaveShortcut(String actionId) {
        return ActionKeymap.getAccelerator(actionId) != null;
    }

    public static KeyStroke getAccelerator(String actionId) {
        if (customPrimaryActionKeymap.containsKey(actionId)) {
            return customPrimaryActionKeymap.get(actionId);
        }
        return ActionProperties.getDefaultAccelerator(actionId);
    }

    public static KeyStroke getAlternateAccelerator(String actionId) {
        if (customAlternateActionKeymap.containsKey(actionId)) {
            return customAlternateActionKeymap.get(actionId);
        }
        return ActionProperties.getDefaultAlternativeAccelerator(actionId);
    }

    public static String getRegisteredActionIdForKeystroke(KeyStroke ks) {
        String actionId = acceleratorMap.getActionId(ks);
        return actionId != null ? actionId : ActionProperties.getDefaultActionForKeyStroke(ks);
    }

    private static int getAcceleratorType(KeyStroke ks) {
        int type = acceleratorMap.getAcceleratorType(ks);
        return type != 0 ? type : ActionProperties.getDefaultAcceleratorType(ks);
    }

    public static Iterator<String> getCustomizedActions() {
        HashSet<String> modifiedActions = new HashSet<String>();
        modifiedActions.addAll(customPrimaryActionKeymap.keySet());
        modifiedActions.addAll(customAlternateActionKeymap.keySet());
        return modifiedActions.iterator();
    }

    private static void registerAction(MainFrame mainFrame, MuAction action) {
        ActionKeymap.registerActionAccelerators(action, mainFrame.getLeftPanel().getFileTable(), 0);
        ActionKeymap.registerActionAccelerators(action, mainFrame.getRightPanel().getFileTable(), 0);
    }

    private static void registerActionAccelerator(MuAction action, KeyStroke accelerator, JComponent comp, int condition) {
        if (accelerator != null) {
            InputMap inputMap = comp.getInputMap(condition);
            ActionMap actionMap = comp.getActionMap();
            Class<?> muActionClass = action.getClass();
            inputMap.put(accelerator, muActionClass);
            actionMap.put(muActionClass, action);
        }
    }

    private static void unregisterAction(MainFrame mainFrame, MuAction action) {
        ActionKeymap.unregisterActionAccelerators(action, mainFrame.getLeftPanel().getFileTable(), 0);
        ActionKeymap.unregisterActionAccelerators(action, mainFrame.getRightPanel().getFileTable(), 0);
    }

    private static void unregisterActionAccelerators(MuAction action, JComponent comp, int condition) {
        ActionKeymap.unregisterActionAccelerator(action, action.getAccelerator(), comp, condition);
        ActionKeymap.unregisterActionAccelerator(action, action.getAlternateAccelerator(), comp, condition);
    }

    private static void unregisterActionAccelerator(MuAction action, KeyStroke accelerator, JComponent comp, int condition) {
        if (accelerator != null) {
            InputMap inputMap = comp.getInputMap(condition);
            ActionMap actionMap = comp.getActionMap();
            Class<?> muActionClass = action.getClass();
            inputMap.remove(accelerator);
            actionMap.remove(muActionClass);
        }
    }

    private static void registerActionAccelerators(String actionId, KeyStroke accelerator, KeyStroke alternateAccelerator) {
        if (accelerator == null) {
            accelerator = alternateAccelerator;
            alternateAccelerator = null;
        }
        if (ActionKeymap.equals(accelerator, ActionProperties.getDefaultAccelerator(actionId)) && ActionKeymap.equals(alternateAccelerator, ActionProperties.getDefaultAlternativeAccelerator(actionId))) {
            customPrimaryActionKeymap.remove(actionId);
            customAlternateActionKeymap.remove(actionId);
            acceleratorMap.remove(accelerator);
            acceleratorMap.remove(alternateAccelerator);
        } else {
            customPrimaryActionKeymap.put(actionId, accelerator);
            acceleratorMap.putAccelerator(accelerator, actionId);
            customAlternateActionKeymap.put(actionId, alternateAccelerator);
            acceleratorMap.putAlternativeAccelerator(alternateAccelerator, actionId);
        }
        for (MuAction action : ActionManager.getActionInstances(actionId)) {
            MainFrame mainFrame = action.getMainFrame();
            ActionKeymap.unregisterAction(mainFrame, action);
            action.setAccelerator(accelerator);
            action.setAlternateAccelerator(alternateAccelerator);
            ActionKeymap.registerAction(mainFrame, action);
        }
    }

    private static boolean equals(Object first, Object second) {
        if (first == null) {
            return second == null;
        }
        return first.equals(second);
    }
}

