/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.action;

import com.mucommander.PlatformManager;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.ui.action.ActionKeymap;
import com.mucommander.ui.action.ActionKeymapReader;
import com.mucommander.ui.action.ActionKeymapWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.helpers.DefaultHandler;

public abstract class ActionKeymapIO
extends DefaultHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActionKeymapIO.class);
    private static AbstractFile actionsFile;
    protected static boolean wereActionsModified;
    private static ActionKeymapWriter writer;

    public static void setActionsFile(String path) throws FileNotFoundException {
        AbstractFile file = FileFactory.getFile(path);
        if (file == null) {
            ActionKeymapIO.setActionsFile(new File(path));
        } else {
            ActionKeymapIO.setActionsFile(file);
        }
    }

    private static void setActionsFile(File file) throws FileNotFoundException {
        ActionKeymapIO.setActionsFile(FileFactory.getFile(file.getAbsolutePath()));
    }

    private static void setActionsFile(AbstractFile file) throws FileNotFoundException {
        if (file.isBrowsable()) {
            throw new FileNotFoundException("Not a valid file: " + file.getAbsolutePath());
        }
        actionsFile = file;
    }

    protected static AbstractFile getActionsFile() throws IOException {
        if (actionsFile == null) {
            return PlatformManager.getPreferencesFolder().getChild("action_keymap.xml");
        }
        return actionsFile;
    }

    public static void setModified() {
        wereActionsModified = true;
    }

    public static void saveActionKeymap() throws IOException {
        if (wereActionsModified) {
            writer.write();
        } else {
            LOGGER.debug("Action keymap not modified, not saving");
        }
    }

    protected static void createEmptyFile() throws IOException {
        writer.create();
    }

    public static void loadActionKeymap() throws Exception {
        AbstractFile actionKeymapFile = ActionKeymapIO.getActionsFile();
        if (actionKeymapFile != null && actionKeymapFile.exists()) {
            ActionKeymapReader reader = new ActionKeymapReader(actionKeymapFile);
            ActionKeymap.registerActions(reader.getPrimaryActionsKeymap(), reader.getAlternateActionsKeymap());
        } else {
            ActionKeymapIO.createEmptyFile();
            LOGGER.debug("action_keymap.xml was not found, created empty file");
        }
    }

    static {
        writer = new ActionKeymapWriter();
    }
}

