/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.action;

import com.mucommander.RuntimeConstants;
import com.mucommander.io.backup.BackupOutputStream;
import com.mucommander.ui.action.ActionKeymap;
import com.mucommander.ui.action.ActionKeymapIO;
import com.mucommander.ui.text.KeyStrokeUtils;
import com.mucommander.xml.XmlAttributes;
import com.mucommander.xml.XmlWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ActionKeymapWriter
extends ActionKeymapIO {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActionKeymapWriter.class);

    ActionKeymapWriter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create() throws IOException {
        BackupOutputStream bos = new BackupOutputStream(ActionKeymapWriter.getActionsFile());
        try {
            new Writer(bos).writeKeyMap(null);
        }
        catch (Exception e) {
            LOGGER.debug("Caught exception", e);
        }
        finally {
            bos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write() throws IOException {
        Hashtable<String, KeyStroke[]> combinedMapping = new Hashtable<String, KeyStroke[]>();
        Iterator<String> modifiedActionsIterator = ActionKeymap.getCustomizedActions();
        while (modifiedActionsIterator.hasNext()) {
            String actionId = modifiedActionsIterator.next();
            KeyStroke[] keyStrokes = new KeyStroke[]{ActionKeymap.getAccelerator(actionId), ActionKeymap.getAlternateAccelerator(actionId)};
            combinedMapping.put(actionId, keyStrokes);
        }
        BackupOutputStream bos = new BackupOutputStream(ActionKeymapWriter.getActionsFile());
        try {
            new Writer(bos).writeKeyMap(combinedMapping);
            wereActionsModified = false;
        }
        catch (Exception e) {
            LOGGER.debug("Caught exception", e);
        }
        finally {
            bos.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Writer {
        private XmlWriter writer = null;

        private Writer(OutputStream stream) throws IOException {
            this.writer = new XmlWriter(stream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeKeyMap(Map<String, KeyStroke[]> actionMap) throws IOException {
            try {
                this.writer.writeCommentLine("See http://trac.mucommander.com/wiki/ActionKeyMap for information on how to customize this file");
                XmlAttributes rootElementAttributes = new XmlAttributes();
                rootElementAttributes.add("version", RuntimeConstants.VERSION);
                this.writer.startElement("keymap", rootElementAttributes, true);
                if (actionMap != null) {
                    for (String actionId : actionMap.keySet()) {
                        this.addMapping(actionId, actionMap.get(actionId));
                    }
                }
            }
            finally {
                this.writer.endElement("keymap");
            }
        }

        private void addMapping(String actionId, KeyStroke[] keyStrokes) throws IOException {
            XmlAttributes attributes = new XmlAttributes();
            attributes.add("id", actionId);
            LOGGER.trace("     Writing mapping of " + actionId + " to " + keyStrokes[0] + " and " + keyStrokes[1]);
            if (keyStrokes[0] != null) {
                attributes.add("keystroke", KeyStrokeUtils.getKeyStrokeRepresentation(keyStrokes[0]));
            }
            if (keyStrokes[1] != null) {
                attributes.add("alt_keystroke", KeyStrokeUtils.getKeyStrokeRepresentation(keyStrokes[1]));
            }
            this.writer.writeStandAloneElement("action", attributes);
        }
    }
}

