/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.action;

import com.mucommander.ui.action.ActionDescriptor;
import com.mucommander.ui.action.ActionFactory;
import com.mucommander.ui.action.ActionKeymap;
import com.mucommander.ui.action.ActionParameters;
import com.mucommander.ui.action.ActionProperties;
import com.mucommander.ui.action.InvokesDialog;
import com.mucommander.ui.action.MuAction;
import com.mucommander.ui.action.impl.AddBookmarkAction;
import com.mucommander.ui.action.impl.BatchRenameAction;
import com.mucommander.ui.action.impl.BringAllToFrontAction;
import com.mucommander.ui.action.impl.CalculateChecksumAction;
import com.mucommander.ui.action.impl.ChangeDateAction;
import com.mucommander.ui.action.impl.ChangeLocationAction;
import com.mucommander.ui.action.impl.ChangePermissionsAction;
import com.mucommander.ui.action.impl.CheckForUpdatesAction;
import com.mucommander.ui.action.impl.CloseDuplicateTabsAction;
import com.mucommander.ui.action.impl.CloseOtherTabsAction;
import com.mucommander.ui.action.impl.CloseTabAction;
import com.mucommander.ui.action.impl.CloseWindowAction;
import com.mucommander.ui.action.impl.CombineFilesAction;
import com.mucommander.ui.action.impl.CompareFoldersAction;
import com.mucommander.ui.action.impl.ConnectToServerAction;
import com.mucommander.ui.action.impl.CopyAction;
import com.mucommander.ui.action.impl.CopyFileNamesAction;
import com.mucommander.ui.action.impl.CopyFilePathsAction;
import com.mucommander.ui.action.impl.CopyFilesToClipboardAction;
import com.mucommander.ui.action.impl.CustomizeCommandBarAction;
import com.mucommander.ui.action.impl.DeleteAction;
import com.mucommander.ui.action.impl.DonateAction;
import com.mucommander.ui.action.impl.EditAction;
import com.mucommander.ui.action.impl.EditBookmarksAction;
import com.mucommander.ui.action.impl.EditCredentialsAction;
import com.mucommander.ui.action.impl.EmailAction;
import com.mucommander.ui.action.impl.EmptyTrashAction;
import com.mucommander.ui.action.impl.ExploreBookmarksAction;
import com.mucommander.ui.action.impl.FocusNextAction;
import com.mucommander.ui.action.impl.FocusPreviousAction;
import com.mucommander.ui.action.impl.GoBackAction;
import com.mucommander.ui.action.impl.GoForwardAction;
import com.mucommander.ui.action.impl.GoToDocumentationAction;
import com.mucommander.ui.action.impl.GoToForumsAction;
import com.mucommander.ui.action.impl.GoToHomeAction;
import com.mucommander.ui.action.impl.GoToParentAction;
import com.mucommander.ui.action.impl.GoToParentInBothPanelsAction;
import com.mucommander.ui.action.impl.GoToParentInOtherPanelAction;
import com.mucommander.ui.action.impl.GoToRootAction;
import com.mucommander.ui.action.impl.GoToWebsiteAction;
import com.mucommander.ui.action.impl.InternalEditAction;
import com.mucommander.ui.action.impl.InternalViewAction;
import com.mucommander.ui.action.impl.InvertSelectionAction;
import com.mucommander.ui.action.impl.LocalCopyAction;
import com.mucommander.ui.action.impl.MarkAllAction;
import com.mucommander.ui.action.impl.MarkExtensionAction;
import com.mucommander.ui.action.impl.MarkGroupAction;
import com.mucommander.ui.action.impl.MarkNextBlockAction;
import com.mucommander.ui.action.impl.MarkNextPageAction;
import com.mucommander.ui.action.impl.MarkNextRowAction;
import com.mucommander.ui.action.impl.MarkPreviousBlockAction;
import com.mucommander.ui.action.impl.MarkPreviousPageAction;
import com.mucommander.ui.action.impl.MarkPreviousRowAction;
import com.mucommander.ui.action.impl.MarkSelectedFileAction;
import com.mucommander.ui.action.impl.MarkToFirstRowAction;
import com.mucommander.ui.action.impl.MarkToLastRowAction;
import com.mucommander.ui.action.impl.MaximizeWindowAction;
import com.mucommander.ui.action.impl.MinimizeWindowAction;
import com.mucommander.ui.action.impl.MkdirAction;
import com.mucommander.ui.action.impl.MkfileAction;
import com.mucommander.ui.action.impl.MoveAction;
import com.mucommander.ui.action.impl.MoveTabToOtherPanelAction;
import com.mucommander.ui.action.impl.NewWindowAction;
import com.mucommander.ui.action.impl.NextTabAction;
import com.mucommander.ui.action.impl.OpenAction;
import com.mucommander.ui.action.impl.OpenInBothPanelsAction;
import com.mucommander.ui.action.impl.OpenInNewTabAction;
import com.mucommander.ui.action.impl.OpenInOtherPanelAction;
import com.mucommander.ui.action.impl.OpenNativelyAction;
import com.mucommander.ui.action.impl.OpenTrashAction;
import com.mucommander.ui.action.impl.OpenURLInBrowserAction;
import com.mucommander.ui.action.impl.PackAction;
import com.mucommander.ui.action.impl.PasteClipboardFilesAction;
import com.mucommander.ui.action.impl.PermanentDeleteAction;
import com.mucommander.ui.action.impl.PopupLeftDriveButtonAction;
import com.mucommander.ui.action.impl.PopupRightDriveButtonAction;
import com.mucommander.ui.action.impl.PreviousTabAction;
import com.mucommander.ui.action.impl.QuitAction;
import com.mucommander.ui.action.impl.RecallNextWindowAction;
import com.mucommander.ui.action.impl.RecallPreviousWindowAction;
import com.mucommander.ui.action.impl.RecallWindow10Action;
import com.mucommander.ui.action.impl.RecallWindow1Action;
import com.mucommander.ui.action.impl.RecallWindow2Action;
import com.mucommander.ui.action.impl.RecallWindow3Action;
import com.mucommander.ui.action.impl.RecallWindow4Action;
import com.mucommander.ui.action.impl.RecallWindow5Action;
import com.mucommander.ui.action.impl.RecallWindow6Action;
import com.mucommander.ui.action.impl.RecallWindow7Action;
import com.mucommander.ui.action.impl.RecallWindow8Action;
import com.mucommander.ui.action.impl.RecallWindow9Action;
import com.mucommander.ui.action.impl.RecallWindowAction;
import com.mucommander.ui.action.impl.RefreshAction;
import com.mucommander.ui.action.impl.RenameAction;
import com.mucommander.ui.action.impl.ReportBugAction;
import com.mucommander.ui.action.impl.RevealInDesktopAction;
import com.mucommander.ui.action.impl.ReverseSortOrderAction;
import com.mucommander.ui.action.impl.RunCommandAction;
import com.mucommander.ui.action.impl.SelectFirstRowAction;
import com.mucommander.ui.action.impl.SelectLastRowAction;
import com.mucommander.ui.action.impl.SelectNextBlockAction;
import com.mucommander.ui.action.impl.SelectNextPageAction;
import com.mucommander.ui.action.impl.SelectNextRowAction;
import com.mucommander.ui.action.impl.SelectPreviousBlockAction;
import com.mucommander.ui.action.impl.SelectPreviousPageAction;
import com.mucommander.ui.action.impl.SelectPreviousRowAction;
import com.mucommander.ui.action.impl.SetSameFolderAction;
import com.mucommander.ui.action.impl.ShowAboutAction;
import com.mucommander.ui.action.impl.ShowBookmarksQLAction;
import com.mucommander.ui.action.impl.ShowDebugConsoleAction;
import com.mucommander.ui.action.impl.ShowFilePropertiesAction;
import com.mucommander.ui.action.impl.ShowKeyboardShortcutsAction;
import com.mucommander.ui.action.impl.ShowParentFoldersQLAction;
import com.mucommander.ui.action.impl.ShowPreferencesAction;
import com.mucommander.ui.action.impl.ShowRecentExecutedFilesQLAction;
import com.mucommander.ui.action.impl.ShowRecentLocationsQLAction;
import com.mucommander.ui.action.impl.ShowRootFoldersQLAction;
import com.mucommander.ui.action.impl.ShowServerConnectionsAction;
import com.mucommander.ui.action.impl.SortByDateAction;
import com.mucommander.ui.action.impl.SortByExtensionAction;
import com.mucommander.ui.action.impl.SortByGroupAction;
import com.mucommander.ui.action.impl.SortByNameAction;
import com.mucommander.ui.action.impl.SortByOwnerAction;
import com.mucommander.ui.action.impl.SortByPermissionsAction;
import com.mucommander.ui.action.impl.SortBySizeAction;
import com.mucommander.ui.action.impl.SplitEquallyAction;
import com.mucommander.ui.action.impl.SplitFileAction;
import com.mucommander.ui.action.impl.SplitHorizontallyAction;
import com.mucommander.ui.action.impl.SplitVerticallyAction;
import com.mucommander.ui.action.impl.StopAction;
import com.mucommander.ui.action.impl.SwapFoldersAction;
import com.mucommander.ui.action.impl.SwitchActiveTableAction;
import com.mucommander.ui.action.impl.ToggleAutoSizeAction;
import com.mucommander.ui.action.impl.ToggleCommandBarAction;
import com.mucommander.ui.action.impl.ToggleDateColumnAction;
import com.mucommander.ui.action.impl.ToggleExtensionColumnAction;
import com.mucommander.ui.action.impl.ToggleGroupColumnAction;
import com.mucommander.ui.action.impl.ToggleHiddenFilesAction;
import com.mucommander.ui.action.impl.ToggleOwnerColumnAction;
import com.mucommander.ui.action.impl.TogglePermissionsColumnAction;
import com.mucommander.ui.action.impl.ToggleShowFoldersFirstAction;
import com.mucommander.ui.action.impl.ToggleSizeColumnAction;
import com.mucommander.ui.action.impl.ToggleStatusBarAction;
import com.mucommander.ui.action.impl.ToggleToolBarAction;
import com.mucommander.ui.action.impl.ToggleTreeAction;
import com.mucommander.ui.action.impl.UnmarkAllAction;
import com.mucommander.ui.action.impl.UnmarkGroupAction;
import com.mucommander.ui.action.impl.UnpackAction;
import com.mucommander.ui.action.impl.ViewAction;
import com.mucommander.ui.main.MainFrame;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActionManager.class);
    private static Map<String, ActionFactory> actionFactories = new Hashtable<String, ActionFactory>();
    private static WeakHashMap<MainFrame, Map<ActionParameters, ActionAndIdPair>> mainFrameActionsMap = new WeakHashMap();
    private static final Pattern pattern = Pattern.compile(".*\\.(.*)?Action");

    public static void registerActions() {
        ActionManager.registerAction(new AddBookmarkAction.Descriptor(), new AddBookmarkAction.Factory());
        ActionManager.registerAction(new BatchRenameAction.Descriptor(), new BatchRenameAction.Factory());
        ActionManager.registerAction(new BringAllToFrontAction.Descriptor(), new BringAllToFrontAction.Factory());
        ActionManager.registerAction(new CalculateChecksumAction.Descriptor(), new CalculateChecksumAction.Factory());
        ActionManager.registerAction(new ChangeDateAction.Descriptor(), new ChangeDateAction.Factory());
        ActionManager.registerAction(new ChangeLocationAction.Descriptor(), new ChangeLocationAction.Factory());
        ActionManager.registerAction(new ChangePermissionsAction.Descriptor(), new ChangePermissionsAction.Factory());
        ActionManager.registerAction(new CheckForUpdatesAction.Descriptor(), new CheckForUpdatesAction.Factory());
        ActionManager.registerAction(new CloseDuplicateTabsAction.Descriptor(), new CloseDuplicateTabsAction.Factory());
        ActionManager.registerAction(new CloseOtherTabsAction.Descriptor(), new CloseOtherTabsAction.Factory());
        ActionManager.registerAction(new CloseWindowAction.Descriptor(), new CloseWindowAction.Factory());
        ActionManager.registerAction(new CloseTabAction.Descriptor(), new CloseTabAction.Factory());
        ActionManager.registerAction(new CompareFoldersAction.Descriptor(), new CompareFoldersAction.Factory());
        ActionManager.registerAction(new ConnectToServerAction.Descriptor(), new ConnectToServerAction.Factory());
        ActionManager.registerAction(new CopyAction.Descriptor(), new CopyAction.Factory());
        ActionManager.registerAction(new CopyFileNamesAction.Descriptor(), new CopyFileNamesAction.Factory());
        ActionManager.registerAction(new CopyFilePathsAction.Descriptor(), new CopyFilePathsAction.Factory());
        ActionManager.registerAction(new CopyFilesToClipboardAction.Descriptor(), new CopyFilesToClipboardAction.Factory());
        ActionManager.registerAction(new FocusPreviousAction.Descriptor(), new FocusPreviousAction.Factory());
        ActionManager.registerAction(new FocusNextAction.Descriptor(), new FocusNextAction.Factory());
        ActionManager.registerAction(new DeleteAction.Descriptor(), new DeleteAction.Factory());
        ActionManager.registerAction(new DonateAction.Descriptor(), new DonateAction.Factory());
        ActionManager.registerAction(new EditAction.Descriptor(), new EditAction.Factory());
        ActionManager.registerAction(new EditBookmarksAction.Descriptor(), new EditBookmarksAction.Factory());
        ActionManager.registerAction(new EditCredentialsAction.Descriptor(), new EditCredentialsAction.Factory());
        ActionManager.registerAction(new EmailAction.Descriptor(), new EmailAction.Factory());
        ActionManager.registerAction(new EmptyTrashAction.Descriptor(), new EmptyTrashAction.Factory());
        ActionManager.registerAction(new ExploreBookmarksAction.Descriptor(), new ExploreBookmarksAction.Factory());
        ActionManager.registerAction(new GoBackAction.Descriptor(), new GoBackAction.Factory());
        ActionManager.registerAction(new GoForwardAction.Descriptor(), new GoForwardAction.Factory());
        ActionManager.registerAction(new GoToDocumentationAction.Descriptor(), new GoToDocumentationAction.Factory());
        ActionManager.registerAction(new GoToForumsAction.Descriptor(), new GoToForumsAction.Factory());
        ActionManager.registerAction(new GoToHomeAction.Descriptor(), new GoToHomeAction.Factory());
        ActionManager.registerAction(new GoToParentAction.Descriptor(), new GoToParentAction.Factory());
        ActionManager.registerAction(new GoToParentInBothPanelsAction.Descriptor(), new GoToParentInBothPanelsAction.Factory());
        ActionManager.registerAction(new GoToParentInOtherPanelAction.Descriptor(), new GoToParentInOtherPanelAction.Factory());
        ActionManager.registerAction(new GoToRootAction.Descriptor(), new GoToRootAction.Factory());
        ActionManager.registerAction(new GoToWebsiteAction.Descriptor(), new GoToWebsiteAction.Factory());
        ActionManager.registerAction(new InternalEditAction.Descriptor(), new InternalEditAction.Factory());
        ActionManager.registerAction(new InternalViewAction.Descriptor(), new InternalViewAction.Factory());
        ActionManager.registerAction(new InvertSelectionAction.Descriptor(), new InvertSelectionAction.Factory());
        ActionManager.registerAction(new LocalCopyAction.Descriptor(), new LocalCopyAction.Factory());
        ActionManager.registerAction(new MarkAllAction.Descriptor(), new MarkAllAction.Factory());
        ActionManager.registerAction(new MarkExtensionAction.Descriptor(), new MarkExtensionAction.Factory());
        ActionManager.registerAction(new MarkGroupAction.Descriptor(), new MarkGroupAction.Factory());
        ActionManager.registerAction(new MarkNextBlockAction.Descriptor(), new MarkNextBlockAction.Factory());
        ActionManager.registerAction(new MarkNextPageAction.Descriptor(), new MarkNextPageAction.Factory());
        ActionManager.registerAction(new MarkNextRowAction.Descriptor(), new MarkNextRowAction.Factory());
        ActionManager.registerAction(new MarkPreviousBlockAction.Descriptor(), new MarkPreviousBlockAction.Factory());
        ActionManager.registerAction(new MarkPreviousPageAction.Descriptor(), new MarkPreviousPageAction.Factory());
        ActionManager.registerAction(new MarkPreviousRowAction.Descriptor(), new MarkPreviousRowAction.Factory());
        ActionManager.registerAction(new MarkSelectedFileAction.Descriptor(), new MarkSelectedFileAction.Factory());
        ActionManager.registerAction(new MarkToFirstRowAction.Descriptor(), new MarkToFirstRowAction.Factory());
        ActionManager.registerAction(new MarkToLastRowAction.Descriptor(), new MarkToLastRowAction.Factory());
        ActionManager.registerAction(new MaximizeWindowAction.Descriptor(), new MaximizeWindowAction.Factory());
        ActionManager.registerAction(new CombineFilesAction.Descriptor(), new CombineFilesAction.Factory());
        ActionManager.registerAction(new MinimizeWindowAction.Descriptor(), new MinimizeWindowAction.Factory());
        ActionManager.registerAction(new MkdirAction.Descriptor(), new MkdirAction.Factory());
        ActionManager.registerAction(new MkfileAction.Descriptor(), new MkfileAction.Factory());
        ActionManager.registerAction(new MoveAction.Descriptor(), new MoveAction.Factory());
        ActionManager.registerAction(new MoveTabToOtherPanelAction.Descriptor(), new MoveTabToOtherPanelAction.Factory());
        ActionManager.registerAction(new NewWindowAction.Descriptor(), new NewWindowAction.Factory());
        ActionManager.registerAction(new NextTabAction.Descriptor(), new NextTabAction.Factory());
        ActionManager.registerAction(new OpenAction.Descriptor(), new OpenAction.Factory());
        ActionManager.registerAction(new OpenInBothPanelsAction.Descriptor(), new OpenInBothPanelsAction.Factory());
        ActionManager.registerAction(new OpenInNewTabAction.Descriptor(), new OpenInNewTabAction.Factory());
        ActionManager.registerAction(new OpenInOtherPanelAction.Descriptor(), new OpenInOtherPanelAction.Factory());
        ActionManager.registerAction(new OpenNativelyAction.Descriptor(), new OpenNativelyAction.Factory());
        ActionManager.registerAction(new OpenTrashAction.Descriptor(), new OpenTrashAction.Factory());
        ActionManager.registerAction(new OpenURLInBrowserAction.Descriptor(), new OpenURLInBrowserAction.Factory());
        ActionManager.registerAction(new PackAction.Descriptor(), new PackAction.Factory());
        ActionManager.registerAction(new PasteClipboardFilesAction.Descriptor(), new PasteClipboardFilesAction.Factory());
        ActionManager.registerAction(new PermanentDeleteAction.Descriptor(), new PermanentDeleteAction.Factory());
        ActionManager.registerAction(new PopupLeftDriveButtonAction.Descriptor(), new PopupLeftDriveButtonAction.Factory());
        ActionManager.registerAction(new PopupRightDriveButtonAction.Descriptor(), new PopupRightDriveButtonAction.Factory());
        ActionManager.registerAction(new PreviousTabAction.Descriptor(), new PreviousTabAction.Factory());
        ActionManager.registerAction(new QuitAction.Descriptor(), new QuitAction.Factory());
        ActionManager.registerAction(new RecallNextWindowAction.Descriptor(), new RecallNextWindowAction.Factory());
        ActionManager.registerAction(new RecallPreviousWindowAction.Descriptor(), new RecallPreviousWindowAction.Factory());
        ActionManager.registerAction(new RecallWindow10Action.Descriptor(), new RecallWindow10Action.Factory());
        ActionManager.registerAction(new RecallWindow1Action.Descriptor(), new RecallWindow1Action.Factory());
        ActionManager.registerAction(new RecallWindow2Action.Descriptor(), new RecallWindow2Action.Factory());
        ActionManager.registerAction(new RecallWindow3Action.Descriptor(), new RecallWindow3Action.Factory());
        ActionManager.registerAction(new RecallWindow4Action.Descriptor(), new RecallWindow4Action.Factory());
        ActionManager.registerAction(new RecallWindow5Action.Descriptor(), new RecallWindow5Action.Factory());
        ActionManager.registerAction(new RecallWindow6Action.Descriptor(), new RecallWindow6Action.Factory());
        ActionManager.registerAction(new RecallWindow7Action.Descriptor(), new RecallWindow7Action.Factory());
        ActionManager.registerAction(new RecallWindow8Action.Descriptor(), new RecallWindow8Action.Factory());
        ActionManager.registerAction(new RecallWindow9Action.Descriptor(), new RecallWindow9Action.Factory());
        ActionManager.registerAction(new RecallWindowAction.Descriptor(), new RecallWindowAction.Factory());
        ActionManager.registerAction(new RefreshAction.Descriptor(), new RefreshAction.Factory());
        ActionManager.registerAction(new RenameAction.Descriptor(), new RenameAction.Factory());
        ActionManager.registerAction(new ReportBugAction.Descriptor(), new ReportBugAction.Factory());
        ActionManager.registerAction(new RevealInDesktopAction.Descriptor(), new RevealInDesktopAction.Factory());
        ActionManager.registerAction(new ReverseSortOrderAction.Descriptor(), new ReverseSortOrderAction.Factory());
        ActionManager.registerAction(new RunCommandAction.Descriptor(), new RunCommandAction.Factory());
        ActionManager.registerAction(new SelectPreviousBlockAction.Descriptor(), new SelectPreviousBlockAction.Factory());
        ActionManager.registerAction(new SelectPreviousPageAction.Descriptor(), new SelectPreviousPageAction.Factory());
        ActionManager.registerAction(new SelectPreviousRowAction.Descriptor(), new SelectPreviousRowAction.Factory());
        ActionManager.registerAction(new SelectNextBlockAction.Descriptor(), new SelectNextBlockAction.Factory());
        ActionManager.registerAction(new SelectNextPageAction.Descriptor(), new SelectNextPageAction.Factory());
        ActionManager.registerAction(new SelectNextRowAction.Descriptor(), new SelectNextRowAction.Factory());
        ActionManager.registerAction(new SelectFirstRowAction.Descriptor(), new SelectFirstRowAction.Factory());
        ActionManager.registerAction(new SelectLastRowAction.Descriptor(), new SelectLastRowAction.Factory());
        ActionManager.registerAction(new SetSameFolderAction.Descriptor(), new SetSameFolderAction.Factory());
        ActionManager.registerAction(new ShowAboutAction.Descriptor(), new ShowAboutAction.Factory());
        ActionManager.registerAction(new ShowBookmarksQLAction.Descriptor(), new ShowBookmarksQLAction.Factory());
        ActionManager.registerAction(new CustomizeCommandBarAction.Descriptor(), new CustomizeCommandBarAction.Factory());
        ActionManager.registerAction(new ShowFilePropertiesAction.Descriptor(), new ShowFilePropertiesAction.Factory());
        ActionManager.registerAction(new ShowKeyboardShortcutsAction.Descriptor(), new ShowKeyboardShortcutsAction.Factory());
        ActionManager.registerAction(new ShowParentFoldersQLAction.Descriptor(), new ShowParentFoldersQLAction.Factory());
        ActionManager.registerAction(new ShowPreferencesAction.Descriptor(), new ShowPreferencesAction.Factory());
        ActionManager.registerAction(new ShowRecentExecutedFilesQLAction.Descriptor(), new ShowRecentExecutedFilesQLAction.Factory());
        ActionManager.registerAction(new ShowRecentLocationsQLAction.Descriptor(), new ShowRecentLocationsQLAction.Factory());
        ActionManager.registerAction(new ShowRootFoldersQLAction.Descriptor(), new ShowRootFoldersQLAction.Factory());
        ActionManager.registerAction(new ShowServerConnectionsAction.Descriptor(), new ShowServerConnectionsAction.Factory());
        ActionManager.registerAction(new ShowDebugConsoleAction.Descriptor(), new ShowDebugConsoleAction.Factory());
        ActionManager.registerAction(new SortByDateAction.Descriptor(), new SortByDateAction.Factory());
        ActionManager.registerAction(new SortByExtensionAction.Descriptor(), new SortByExtensionAction.Factory());
        ActionManager.registerAction(new SortByGroupAction.Descriptor(), new SortByGroupAction.Factory());
        ActionManager.registerAction(new SortByNameAction.Descriptor(), new SortByNameAction.Factory());
        ActionManager.registerAction(new SortByOwnerAction.Descriptor(), new SortByOwnerAction.Factory());
        ActionManager.registerAction(new SortByPermissionsAction.Descriptor(), new SortByPermissionsAction.Factory());
        ActionManager.registerAction(new SortBySizeAction.Descriptor(), new SortBySizeAction.Factory());
        ActionManager.registerAction(new SplitEquallyAction.Descriptor(), new SplitEquallyAction.Factory());
        ActionManager.registerAction(new SplitFileAction.Descriptor(), new SplitFileAction.Factory());
        ActionManager.registerAction(new SplitHorizontallyAction.Descriptor(), new SplitHorizontallyAction.Factory());
        ActionManager.registerAction(new SplitVerticallyAction.Descriptor(), new SplitVerticallyAction.Factory());
        ActionManager.registerAction(new StopAction.Descriptor(), new StopAction.Factory());
        ActionManager.registerAction(new SwapFoldersAction.Descriptor(), new SwapFoldersAction.Factory());
        ActionManager.registerAction(new SwitchActiveTableAction.Descriptor(), new SwitchActiveTableAction.Factory());
        ActionManager.registerAction(new ToggleAutoSizeAction.Descriptor(), new ToggleAutoSizeAction.Factory());
        ActionManager.registerAction(new ToggleCommandBarAction.Descriptor(), new ToggleCommandBarAction.Factory());
        ActionManager.registerAction(new ToggleDateColumnAction.Descriptor(), new ToggleDateColumnAction.Factory());
        ActionManager.registerAction(new ToggleExtensionColumnAction.Descriptor(), new ToggleExtensionColumnAction.Factory());
        ActionManager.registerAction(new ToggleGroupColumnAction.Descriptor(), new ToggleGroupColumnAction.Factory());
        ActionManager.registerAction(new ToggleHiddenFilesAction.Descriptor(), new ToggleHiddenFilesAction.Factory());
        ActionManager.registerAction(new ToggleOwnerColumnAction.Descriptor(), new ToggleOwnerColumnAction.Factory());
        ActionManager.registerAction(new TogglePermissionsColumnAction.Descriptor(), new TogglePermissionsColumnAction.Factory());
        ActionManager.registerAction(new ToggleShowFoldersFirstAction.Descriptor(), new ToggleShowFoldersFirstAction.Factory());
        ActionManager.registerAction(new ToggleSizeColumnAction.Descriptor(), new ToggleSizeColumnAction.Factory());
        ActionManager.registerAction(new ToggleStatusBarAction.Descriptor(), new ToggleStatusBarAction.Factory());
        ActionManager.registerAction(new ToggleToolBarAction.Descriptor(), new ToggleToolBarAction.Factory());
        ActionManager.registerAction(new ToggleTreeAction.Descriptor(), new ToggleTreeAction.Factory());
        ActionManager.registerAction(new UnmarkAllAction.Descriptor(), new UnmarkAllAction.Factory());
        ActionManager.registerAction(new UnmarkGroupAction.Descriptor(), new UnmarkGroupAction.Factory());
        ActionManager.registerAction(new UnpackAction.Descriptor(), new UnpackAction.Factory());
        ActionManager.registerAction(new ViewAction.Descriptor(), new ViewAction.Factory());
    }

    public static void registerAction(ActionDescriptor actionDescriptor, ActionFactory actionFactory) {
        actionFactories.put(actionDescriptor.getId(), actionFactory);
        ActionProperties.addActionDescriptor(actionDescriptor);
    }

    public static Iterator<String> getActionIds() {
        return actionFactories.keySet().iterator();
    }

    public static String extrapolateId(String actionClassPath) {
        if (actionClassPath == null) {
            return null;
        }
        Matcher matcher = pattern.matcher(actionClassPath);
        return matcher.matches() ? matcher.group(1) : actionClassPath;
    }

    public static boolean isActionExist(String actionId) {
        return actionId != null && actionFactories.containsKey(actionId);
    }

    public static MuAction getActionInstance(String actionId, MainFrame mainFrame) {
        return ActionManager.getActionInstance(new ActionParameters(actionId), mainFrame);
    }

    public static MuAction getActionInstance(ActionParameters actionParameters, MainFrame mainFrame) {
        Object object;
        Cloneable cloneable;
        Map<ActionParameters, ActionAndIdPair> map = mainFrameActionsMap.get(mainFrame);
        if (map == null) {
            map = new Hashtable<ActionParameters, ActionAndIdPair>();
            mainFrameActionsMap.put(mainFrame, map);
        }
        if (map.containsKey(actionParameters)) {
            return map.get(actionParameters).getAction();
        }
        String string = actionParameters.getActionId();
        ActionFactory actionFactory = actionFactories.get(string);
        if (actionFactory == null) {
            LOGGER.debug("couldn't initiate action: " + string + ", its factory wasn't found");
            return null;
        }
        Map<String, Object> map2 = actionParameters.getInitProperties();
        if (map2 == null) {
            map2 = new Hashtable<String, Object>();
        } else if (!map2.isEmpty()) {
            cloneable = new Hashtable<String, Object>();
            cloneable.putAll(map2);
            map2 = cloneable;
        }
        cloneable = actionFactory.createAction(mainFrame, map2);
        map.put(actionParameters, new ActionAndIdPair((MuAction)cloneable, string));
        if (((MuAction)cloneable).getLabel() == null) {
            object = ActionProperties.getActionLabel(string);
            if (cloneable instanceof InvokesDialog) {
                object = (String)object + "...";
            }
            ((MuAction)cloneable).setLabel((String)object);
            String string2 = ActionProperties.getActionTooltip(string);
            if (string2 != null) {
                ((MuAction)cloneable).setToolTipText(string2);
            }
        }
        if (((MuAction)cloneable).getAccelerator() == null) {
            object = ActionKeymap.getAccelerator(string);
            if (object != null) {
                ((MuAction)cloneable).setAccelerator((KeyStroke)object);
            }
            if ((object = ActionKeymap.getAlternateAccelerator(string)) != null) {
                ((MuAction)cloneable).setAlternateAccelerator((KeyStroke)object);
            }
        }
        if (((MuAction)cloneable).getIcon() == null && (object = ActionProperties.getActionIcon(string)) != null) {
            ((MuAction)cloneable).setIcon((ImageIcon)object);
        }
        return cloneable;
    }

    public static List<MuAction> getActionInstances(String muActionId) {
        Vector<MuAction> actionInstances = new Vector<MuAction>();
        block0: for (Map<ActionParameters, ActionAndIdPair> actionParametersActionAndIdPairHashtable : mainFrameActionsMap.values()) {
            for (ActionAndIdPair actionAndIdPair : actionParametersActionAndIdPairHashtable.values()) {
                if (!actionAndIdPair.getId().equals(muActionId)) continue;
                actionInstances.add(actionAndIdPair.getAction());
                continue block0;
            }
        }
        return actionInstances;
    }

    public static boolean performAction(String actionId, MainFrame mainFrame) {
        return ActionManager.performAction(new ActionParameters(actionId), mainFrame);
    }

    public static boolean performAction(ActionParameters actionParameters, MainFrame mainFrame) {
        MuAction action = ActionManager.getActionInstance(actionParameters, mainFrame);
        if (action == null) {
            return false;
        }
        action.performAction();
        return true;
    }

    private static class ActionAndIdPair {
        private MuAction action;
        private String id;

        public ActionAndIdPair(MuAction action, String id) {
            this.action = action;
            this.id = id;
        }

        public MuAction getAction() {
            return this.action;
        }

        public String getId() {
            return this.id;
        }
    }
}

