/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.action;

import com.mucommander.ui.action.AcceleratorMap;
import com.mucommander.ui.action.ActionCategory;
import com.mucommander.ui.action.ActionDescriptor;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionProperties {
    private static Map<String, ActionDescriptor> actionDescriptors = new Hashtable<String, ActionDescriptor>();
    private static ActionDescriptor nullActionDescriptor = new NullActionDescriptor();
    private static TreeSet<ActionCategory> actionCategories = new TreeSet();
    private static HashMap<String, KeyStroke> defaultPrimaryActionKeymap = new HashMap();
    private static HashMap<String, KeyStroke> defaultAlternateActionKeymap = new HashMap();
    private static AcceleratorMap defaultAcceleratorMap = new AcceleratorMap();

    public static void addActionDescriptor(ActionDescriptor actionDescriptor) {
        KeyStroke defaultActionAlternativeKeyStroke;
        KeyStroke defaultActionKeyStroke;
        String actionId = actionDescriptor.getId();
        actionDescriptors.put(actionId, actionDescriptor);
        ActionCategory category = actionDescriptor.getCategory();
        if (category != null) {
            actionCategories.add(category);
        }
        if ((defaultActionKeyStroke = actionDescriptor.getDefaultKeyStroke()) != null) {
            defaultPrimaryActionKeymap.put(actionId, defaultActionKeyStroke);
            defaultAcceleratorMap.putAccelerator(defaultActionKeyStroke, actionId);
        }
        if ((defaultActionAlternativeKeyStroke = actionDescriptor.getDefaultAltKeyStroke()) != null) {
            defaultAlternateActionKeymap.put(actionId, defaultActionAlternativeKeyStroke);
            defaultAcceleratorMap.putAlternativeAccelerator(defaultActionAlternativeKeyStroke, actionId);
        }
    }

    public static ActionDescriptor getActionDescriptor(String actionId) {
        return actionDescriptors.get(actionId);
    }

    public static String getActionDescription(String actionId) {
        return ActionProperties.getNullSafeActionDescriptor(actionId).getDescription();
    }

    public static ActionCategory getActionCategory(String actionId) {
        return ActionProperties.getNullSafeActionDescriptor(actionId).getCategory();
    }

    public static KeyStroke getDefaultAccelerator(String actionId) {
        return defaultPrimaryActionKeymap.get(actionId);
    }

    public static KeyStroke getDefaultAlternativeAccelerator(String actionId) {
        return defaultAlternateActionKeymap.get(actionId);
    }

    static String getDefaultActionForKeyStroke(KeyStroke keyStroke) {
        return defaultAcceleratorMap.getActionId(keyStroke);
    }

    static int getDefaultAcceleratorType(KeyStroke keyStroke) {
        return defaultAcceleratorMap.getAcceleratorType(keyStroke);
    }

    public static String getActionLabel(String actionId) {
        return ActionProperties.getNullSafeActionDescriptor(actionId).getLabel();
    }

    public static String getActionLabelKey(String actionId) {
        return ActionProperties.getNullSafeActionDescriptor(actionId).getLabelKey();
    }

    public static ImageIcon getActionIcon(String actionId) {
        return ActionProperties.getNullSafeActionDescriptor(actionId).getIcon();
    }

    public static String getActionTooltip(String actionId) {
        return ActionProperties.getNullSafeActionDescriptor(actionId).getTooltip();
    }

    public static Set<ActionCategory> getActionCategories() {
        return actionCategories;
    }

    private static ActionDescriptor getNullSafeActionDescriptor(String actionId) {
        ActionDescriptor actionDescriptor = actionDescriptors.get(actionId);
        return actionDescriptor != null ? actionDescriptor : nullActionDescriptor;
    }

    private static class NullActionDescriptor
    implements ActionDescriptor {
        private NullActionDescriptor() {
        }

        public ActionCategory getCategory() {
            return null;
        }

        public KeyStroke getDefaultAltKeyStroke() {
            return null;
        }

        public KeyStroke getDefaultKeyStroke() {
            return null;
        }

        public String getDescription() {
            return null;
        }

        public ImageIcon getIcon() {
            return null;
        }

        public String getId() {
            return null;
        }

        public String getLabel() {
            return null;
        }

        public String getLabelKey() {
            return null;
        }

        public String getTooltip() {
            return null;
        }

        public boolean isParameterized() {
            return false;
        }
    }
}

