/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.action;

import com.mucommander.commons.file.util.ResourceLoader;
import com.mucommander.ui.icon.IconManager;
import com.mucommander.ui.main.MainFrame;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MuAction
extends AbstractAction {
    protected MainFrame mainFrame;
    private boolean honourNoEventsMode = true;
    private boolean performActionInSeparateThread = false;

    public MuAction(MainFrame mainFrame, Map<String, Object> properties) {
        this.mainFrame = mainFrame;
        for (String key : properties.keySet()) {
            this.putValue(key, properties.get(key));
        }
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    public String getLabel() {
        return (String)this.getValue("Name");
    }

    public void setLabel(String label) {
        this.putValue("Name", label);
    }

    public void setToolTipText(String toolTipText) {
        this.putValue("ShortDescription", toolTipText);
    }

    public ImageIcon getIcon() {
        return (ImageIcon)this.getValue("SmallIcon");
    }

    public void setIcon(ImageIcon icon) {
        this.putValue("SmallIcon", icon);
    }

    public KeyStroke getAccelerator() {
        return (KeyStroke)this.getValue("AcceleratorKey");
    }

    public void setAccelerator(KeyStroke keyStroke) {
        this.putValue("AcceleratorKey", keyStroke);
    }

    public KeyStroke getAlternateAccelerator() {
        return (KeyStroke)this.getValue("alternate_accelerator");
    }

    public void setAlternateAccelerator(KeyStroke keyStroke) {
        this.putValue("alternate_accelerator", keyStroke);
    }

    protected boolean acceleratorsEqual(KeyStroke ks1, KeyStroke ks2) {
        return ks1.getKeyChar() == ks2.getKeyChar() && ks1.getKeyCode() == ks2.getKeyCode() && ks1.getModifiers() == ks2.getModifiers();
    }

    public boolean isAccelerator(KeyStroke keyStroke) {
        KeyStroke accelerator = this.getAccelerator();
        if (accelerator != null && this.acceleratorsEqual(accelerator, keyStroke)) {
            return true;
        }
        accelerator = this.getAlternateAccelerator();
        return accelerator != null && this.acceleratorsEqual(accelerator, keyStroke);
    }

    public String getAcceleratorText() {
        KeyStroke accelerator = this.getAccelerator();
        if (accelerator == null) {
            return null;
        }
        String text = KeyEvent.getKeyText(accelerator.getKeyCode());
        int modifiers = accelerator.getModifiers();
        if (modifiers != 0) {
            text = KeyEvent.getKeyModifiersText(modifiers) + "+" + text;
        }
        return text;
    }

    public boolean honourNoEventsMode() {
        return this.honourNoEventsMode;
    }

    public void setHonourNoEventsMode(boolean honourNoEventsMode) {
        this.honourNoEventsMode = honourNoEventsMode;
    }

    public boolean performActionInSeparateThread() {
        return this.performActionInSeparateThread;
    }

    public void setPerformActionInSeparateThread(boolean performActionInSeparateThread) {
        this.performActionInSeparateThread = performActionInSeparateThread;
    }

    public static ImageIcon getStandardIcon(Class<? extends MuAction> action) {
        String iconPath = MuAction.getStandardIconPath(action);
        if (ResourceLoader.getResourceAsURL(iconPath) == null) {
            return null;
        }
        return IconManager.getIcon(iconPath);
    }

    public static String getStandardIconPath(Class<? extends MuAction> action) {
        return IconManager.getIconSetFolder(1) + action.getName() + ".png";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.mainFrame.getNoEventsMode() || !this.honourNoEventsMode()) {
            if (this.performActionInSeparateThread()) {
                new Thread(){

                    public void run() {
                        MuAction.this.performAction();
                    }
                }.start();
            } else {
                this.performAction();
            }
        }
    }

    public abstract void performAction();
}

