/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.action.impl;

import com.mucommander.command.Command;
import com.mucommander.commons.file.impl.local.LocalFile;
import com.mucommander.commons.file.util.FileSet;
import com.mucommander.job.TempOpenWithJob;
import com.mucommander.process.ProcessRunner;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.MuAction;
import com.mucommander.ui.dialog.InformationDialog;
import com.mucommander.ui.dialog.file.ProgressDialog;
import com.mucommander.ui.main.MainFrame;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandAction
extends MuAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandAction.class);
    private Command command;

    public CommandAction(MainFrame mainFrame, Map<String, Object> properties, Command command) {
        super(mainFrame, properties);
        this.command = command;
        this.setLabel(command.getDisplayName());
    }

    @Override
    public void performAction() {
        FileSet fileSet = this.mainFrame.getActiveTable().getSelectedFiles();
        if (fileSet.size() == 0) {
            return;
        }
        if (fileSet.getBaseFolder().getURL().getScheme().equals("file") && fileSet.getBaseFolder().hasAncestor(LocalFile.class)) {
            try {
                ProcessRunner.execute(this.command.getTokens(fileSet), fileSet.getBaseFolder());
            }
            catch (Exception exception) {
                InformationDialog.showErrorDialog(this.mainFrame);
                LOGGER.debug("Failed to execute command: " + this.command.getCommand(), exception);
            }
        } else {
            ProgressDialog progressDialog = new ProgressDialog(this.mainFrame, Translator.get("copy_dialog.copying", new String[0]));
            progressDialog.start(new TempOpenWithJob(new ProgressDialog(this.mainFrame, Translator.get("copy_dialog.copying", new String[0])), this.mainFrame, fileSet, this.command));
        }
    }
}

