/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.action.impl;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.ui.action.AbstractActionDescriptor;
import com.mucommander.ui.action.ActionCategories;
import com.mucommander.ui.action.ActionCategory;
import com.mucommander.ui.action.ActionFactory;
import com.mucommander.ui.action.MuAction;
import com.mucommander.ui.action.impl.ParentFolderAction;
import com.mucommander.ui.main.FolderPanel;
import com.mucommander.ui.main.MainFrame;
import java.util.Map;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoToParentAction
extends ParentFolderAction {
    public GoToParentAction(MainFrame mainFrame, Map<String, Object> properties) {
        super(mainFrame, properties);
    }

    @Override
    protected void toggleEnabledState() {
        this.setEnabled(this.mainFrame.getActivePanel().getCurrentFolder().getParent() != null);
    }

    protected boolean goToParent(FolderPanel sourcePanel, FolderPanel destPanel) {
        AbstractFile parent = sourcePanel.getCurrentFolder().getParent();
        if (parent != null) {
            destPanel.tryChangeCurrentFolder(parent, null, true);
            return true;
        }
        return false;
    }

    protected boolean goToParent(FolderPanel panel) {
        return this.goToParent(panel, panel);
    }

    @Override
    public void performAction() {
        this.goToParent(this.mainFrame.getActivePanel());
    }

    public static class Descriptor
    extends AbstractActionDescriptor {
        public String getId() {
            return "GoToParent";
        }

        public ActionCategory getCategory() {
            return ActionCategories.NAVIGATION;
        }

        public KeyStroke getDefaultAltKeyStroke() {
            return KeyStroke.getKeyStroke(37, 0);
        }

        public KeyStroke getDefaultKeyStroke() {
            return KeyStroke.getKeyStroke(8, 0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements ActionFactory {
        @Override
        public MuAction createAction(MainFrame mainFrame, Map<String, Object> properties) {
            return new GoToParentAction(mainFrame, properties);
        }
    }
}

