/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.action.impl;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.ui.action.AbstractActionDescriptor;
import com.mucommander.ui.action.ActionCategories;
import com.mucommander.ui.action.ActionCategory;
import com.mucommander.ui.action.ActionFactory;
import com.mucommander.ui.action.MuAction;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.main.table.FileTable;
import com.mucommander.ui.main.table.FileTableModel;
import java.util.Map;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvertSelectionAction
extends MuAction {
    public InvertSelectionAction(MainFrame mainFrame, Map<String, Object> properties) {
        super(mainFrame, properties);
    }

    @Override
    public void performAction() {
        FileTable fileTable = this.mainFrame.getActiveTable();
        FileTableModel tableModel = fileTable.getFileTableModel();
        int nbRows = tableModel.getRowCount();
        for (int i = tableModel.getFirstMarkableRow(); i < nbRows; ++i) {
            AbstractFile file = tableModel.getFileAtRow(i);
            if (file.isDirectory()) continue;
            tableModel.setRowMarked(i, !tableModel.isRowMarked(i));
        }
        fileTable.repaint();
        fileTable.fireMarkedFilesChangedEvent();
    }

    public static class Descriptor
    extends AbstractActionDescriptor {
        public String getId() {
            return "InvertSelection";
        }

        public ActionCategory getCategory() {
            return ActionCategories.SELECTION;
        }

        public KeyStroke getDefaultAltKeyStroke() {
            return null;
        }

        public KeyStroke getDefaultKeyStroke() {
            return KeyStroke.getKeyStroke(106, 0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements ActionFactory {
        @Override
        public MuAction createAction(MainFrame mainFrame, Map<String, Object> properties) {
            return new InvertSelectionAction(mainFrame, properties);
        }
    }
}

