/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.action.impl;

import com.mucommander.ui.action.AbstractActionDescriptor;
import com.mucommander.ui.action.ActionCategories;
import com.mucommander.ui.action.ActionCategory;
import com.mucommander.ui.action.ActionFactory;
import com.mucommander.ui.action.MuAction;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.main.table.FileTable;
import com.mucommander.ui.main.table.FileTableModel;
import java.util.Map;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkAllAction
extends MuAction {
    private boolean mark;

    protected MarkAllAction(MainFrame mainFrame, Map<String, Object> properties, boolean mark) {
        super(mainFrame, properties);
        this.mark = mark;
    }

    public MarkAllAction(MainFrame mainFrame, Map<String, Object> properties) {
        this(mainFrame, properties, true);
    }

    @Override
    public void performAction() {
        FileTable fileTable = this.mainFrame.getActiveTable();
        FileTableModel tableModel = fileTable.getFileTableModel();
        int nbRows = tableModel.getRowCount();
        for (int i = tableModel.getFirstMarkableRow(); i < nbRows; ++i) {
            tableModel.setRowMarked(i, this.mark);
        }
        fileTable.repaint();
        fileTable.fireMarkedFilesChangedEvent();
    }

    public static class Descriptor
    extends AbstractActionDescriptor {
        public String getId() {
            return "MarkAll";
        }

        public ActionCategory getCategory() {
            return ActionCategories.SELECTION;
        }

        public KeyStroke getDefaultAltKeyStroke() {
            return null;
        }

        public KeyStroke getDefaultKeyStroke() {
            return KeyStroke.getKeyStroke(65, 128);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements ActionFactory {
        @Override
        public MuAction createAction(MainFrame mainFrame, Map<String, Object> properties) {
            return new MarkAllAction(mainFrame, properties);
        }
    }
}

